/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.maven.scm.provider.p4.command;

import com.perforce.maven.scm.provider.p4.command.P4FileStatusMapper;
import com.perforce.p4java.core.file.IFileSpec;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.scm.ScmFile;
import org.apache.maven.scm.ScmFileStatus;

public abstract class P4Result {
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    protected boolean success = true;
    protected List<ScmFile> commandResult = new ArrayList<ScmFile>();
    protected String commandOutput = "";

    public void process(List<IFileSpec> fileSpecs) {
        this.processResult(fileSpecs);
        this.processOutput(fileSpecs);
    }

    public void removeResultStatusType(ScmFileStatus scmStatus) {
        ArrayList<ScmFile> newResults = new ArrayList<ScmFile>(this.commandResult.size());
        for (ScmFile scmFile : this.commandResult) {
            if (scmFile.getStatus() == scmStatus) continue;
            newResults.add(scmFile);
        }
        this.commandResult = newResults;
    }

    private void processOutput(List<IFileSpec> fileSpecs) {
        if (fileSpecs != null) {
            for (IFileSpec fileSpec : fileSpecs) {
                if (fileSpec == null) continue;
                StringBuilder sb = new StringBuilder();
                if (fileSpec.toString() != null) {
                    sb.append("fileSpec").append("=").append(fileSpec.toString()).append(LINE_SEPARATOR);
                }
                if (fileSpec.getOpStatus() != null) {
                    sb.append("opStatus").append("=").append(fileSpec.getOpStatus()).append(LINE_SEPARATOR);
                }
                if (fileSpec.getStatusMessage() != null) {
                    sb.append("statusMessage").append("=").append(fileSpec.getStatusMessage()).append(LINE_SEPARATOR);
                }
                if (fileSpec.getDepotPath() != null) {
                    sb.append("depotPath").append("=").append(fileSpec.getDepotPath()).append(LINE_SEPARATOR);
                }
                if (fileSpec.getEndRevision() >= 0) {
                    sb.append("endRevision").append("=").append(fileSpec.getEndRevision()).append(LINE_SEPARATOR);
                }
                if (fileSpec.getChangelistId() >= 0) {
                    sb.append("changelistId").append("=").append(fileSpec.getChangelistId()).append(LINE_SEPARATOR);
                }
                if (fileSpec.getAction() != null) {
                    sb.append("action").append("=").append(fileSpec.getAction()).append(LINE_SEPARATOR);
                }
                if (fileSpec.getFileType() != null) {
                    sb.append("fileType").append("=").append(fileSpec.getFileType()).append(LINE_SEPARATOR);
                }
                if (fileSpec.getDate() != null) {
                    sb.append("date").append("=").append(fileSpec.getDate()).append(LINE_SEPARATOR);
                }
                this.commandOutput = this.commandOutput + sb.toString();
            }
        }
    }

    private void processResult(List<IFileSpec> fileSpecs) {
        if (fileSpecs != null) {
            for (IFileSpec fileSpec : fileSpecs) {
                if (fileSpec == null) continue;
                ScmFileStatus status = null;
                StringBuilder sb = new StringBuilder();
                if (fileSpec.getDepotPath() == null) continue;
                sb.append(fileSpec.getDepotPath());
                if (fileSpec.getAction() != null) {
                    status = P4FileStatusMapper.getFileStatus(fileSpec.getAction().toString());
                }
                this.commandResult.add(new ScmFile(sb.toString(), status));
                if (fileSpec.getOpStatus() == null) continue;
                switch (fileSpec.getOpStatus()) {
                    case UNKNOWN: {
                        this.success = false;
                        break;
                    }
                    case VALID: {
                        break;
                    }
                    case INFO: {
                        break;
                    }
                    case CLIENT_ERROR: {
                        this.success = false;
                        break;
                    }
                    case ERROR: {
                        if (fileSpec.getSeverityCode() <= 2) break;
                        this.success = false;
                        break;
                    }
                }
            }
        }
    }

    public abstract String processMessage(String var1);

    public List<ScmFile> getCommandResult() {
        return this.commandResult;
    }

    public String getCommandOutput() {
        return this.commandOutput;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }
}

