/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.maven.scm.provider.p4.command.add;

import com.perforce.maven.scm.provider.p4.command.P4Command;
import com.perforce.maven.scm.provider.p4.command.add.P4AddResult;
import com.perforce.maven.scm.provider.p4.util.P4Utils;
import com.perforce.p4java.client.IClient;
import com.perforce.p4java.core.file.IFileSpec;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.option.client.AddFilesOptions;
import java.io.IOException;
import java.util.List;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFile;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.command.add.AbstractAddCommand;
import org.apache.maven.scm.command.add.AddScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.codehaus.plexus.util.StringUtils;

public class P4AddCommand
extends AbstractAddCommand
implements P4Command {
    public static final String command = "Perforce add command";
    private IClient client;

    @Override
    public void setClient(IClient client) {
        this.client = client;
    }

    protected ScmResult executeAddCommand(ScmProviderRepository repo, ScmFileSet files, String message, boolean binary) throws ScmException {
        List<IFileSpec> fileSpecs;
        P4AddResult p4Result;
        block6: {
            p4Result = new P4AddResult();
            if (files.getFileList().isEmpty() && StringUtils.isBlank((String)files.getIncludes())) {
                try {
                    files = new ScmFileSet(files.getBasedir(), "**", files.getExcludes());
                }
                catch (IOException e) {
                    if (!this.getLogger().isErrorEnabled()) break block6;
                    this.getLogger().error((Throwable)e);
                }
            }
        }
        if (!(fileSpecs = P4Utils.scmFileSet2P4FileSpecsWithNoP4WildCard(files)).isEmpty()) {
            AddFilesOptions addFilesOptions = new AddFilesOptions();
            addFilesOptions.setUseWildcards(true);
            try {
                List retFileSpecs = this.client.addFiles(fileSpecs, addFilesOptions);
                p4Result.process(retFileSpecs);
                p4Result.processAdditions(retFileSpecs);
            }
            catch (P4JavaException e) {
                throw new ScmException(e.getLocalizedMessage(), (Throwable)e);
            }
        }
        List<ScmFile> additions = p4Result.getAdditions();
        return new AddScmResult(command, additions);
    }
}

