/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.maven.scm.provider.p4.command.blame;

import com.perforce.maven.scm.provider.p4.command.P4Command;
import com.perforce.maven.scm.provider.p4.command.blame.P4BlameResult;
import com.perforce.maven.scm.provider.p4.util.P4Utils;
import com.perforce.p4java.client.IClient;
import com.perforce.p4java.core.file.FileSpecBuilder;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.option.server.GetFileAnnotationsOptions;
import com.perforce.p4java.option.server.GetRevisionHistoryOptions;
import com.perforce.p4java.server.IOptionsServer;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.command.blame.AbstractBlameCommand;
import org.apache.maven.scm.command.blame.BlameLine;
import org.apache.maven.scm.command.blame.BlameScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;

public class P4BlameCommand
extends AbstractBlameCommand
implements P4Command {
    public static final String command = "Perforce annotate command";
    private IClient client;

    @Override
    public void setClient(IClient client) {
        this.client = client;
    }

    public BlameScmResult executeBlameCommand(ScmProviderRepository repo, ScmFileSet workingDirectory, String filename) throws ScmException {
        P4BlameResult p4Result = new P4BlameResult();
        List fileSpecs = FileSpecBuilder.makeFileSpecList((String)P4Utils.encodeWildcards(new File(workingDirectory.getBasedir(), filename).getAbsolutePath()));
        try {
            IOptionsServer server = (IOptionsServer)this.client.getServer();
            GetFileAnnotationsOptions getFileAnnotationsOptions = new GetFileAnnotationsOptions();
            List fileAnnotations = server.getFileAnnotations(fileSpecs, getFileAnnotationsOptions);
            p4Result.processBlameLines(fileAnnotations);
            GetRevisionHistoryOptions getRevisionHistoryOptions = new GetRevisionHistoryOptions();
            Map revisionMap = server.getRevisionHistory(fileSpecs, getRevisionHistoryOptions);
            p4Result.processRevisionHistory(revisionMap);
        }
        catch (P4JavaException e) {
            throw new ScmException(e.getLocalizedMessage(), (Throwable)e);
        }
        List<BlameLine> lines = p4Result.getBlameLines();
        for (int i = 0; i < lines.size(); ++i) {
            BlameLine line = lines.get(i);
            String revision = line.getRevision();
            line.setAuthor(p4Result.getAuthor(revision));
            line.setDate(p4Result.getDate(revision));
        }
        return new BlameScmResult(command, lines);
    }
}

