/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.maven.scm.provider.p4.command.branch;

import com.perforce.maven.scm.provider.p4.command.P4Command;
import com.perforce.maven.scm.provider.p4.command.branch.P4BranchResult;
import com.perforce.maven.scm.provider.p4.repository.P4ScmProviderRepository;
import com.perforce.maven.scm.provider.p4.util.P4Utils;
import com.perforce.p4java.client.IClient;
import com.perforce.p4java.core.file.FileSpecBuilder;
import com.perforce.p4java.core.file.IFileSpec;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.option.client.PopulateFilesOptions;
import java.util.List;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.command.branch.AbstractBranchCommand;
import org.apache.maven.scm.command.branch.BranchScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.codehaus.plexus.util.StringUtils;

public class P4BranchCommand
extends AbstractBranchCommand
implements P4Command {
    public static final String command = "Perforce integrate command";
    private IClient client;

    @Override
    public void setClient(IClient client) {
        this.client = client;
    }

    protected ScmResult executeBranchCommand(ScmProviderRepository repo, ScmFileSet files, String branchPath, String message) throws ScmException {
        if (StringUtils.isBlank((String)branchPath)) {
            throw new ScmException("Branch name must be specified");
        }
        branchPath = P4Utils.encodeWildcards(branchPath.trim());
        P4BranchResult p4Result = new P4BranchResult();
        try {
            String repoPath;
            String left = repoPath = ((P4ScmProviderRepository)repo).getPath();
            if (!P4Utils.isRepoPathValid(this.client, left)) {
                left = P4Utils.getRepoLocation(this.client, files.getBasedir());
            }
            if (left == null) {
                throw new ScmException("Invalid path: " + repoPath + "|" + files.getBasedir());
            }
            String right = branchPath;
            left = P4Utils.getCanonicalRepoPath(left);
            right = P4Utils.getCanonicalRepoPath(right);
            List leftFileSpecs = FileSpecBuilder.makeFileSpecList((String)left);
            List rightFileSpecs = FileSpecBuilder.makeFileSpecList((String)right);
            List retFileSpecs = this.client.populateFiles((IFileSpec)leftFileSpecs.get(0), rightFileSpecs, new PopulateFilesOptions());
            p4Result.process(retFileSpecs);
        }
        catch (P4JavaException e) {
            throw new ScmException(e.getLocalizedMessage(), (Throwable)e);
        }
        return new BranchScmResult(command, p4Result.getCommandResult());
    }
}

