/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.maven.scm.provider.p4.command.changelog;

import com.perforce.maven.scm.provider.p4.command.P4Command;
import com.perforce.p4java.client.IClient;
import com.perforce.p4java.core.IChangelist;
import com.perforce.p4java.core.IChangelistSummary;
import com.perforce.p4java.core.file.FileSpecBuilder;
import com.perforce.p4java.core.file.IFileSpec;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.option.server.GetChangelistsOptions;
import com.perforce.p4java.server.IOptionsServer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.maven.scm.ChangeFile;
import org.apache.maven.scm.ChangeSet;
import org.apache.maven.scm.ScmBranch;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmVersion;
import org.apache.maven.scm.command.changelog.AbstractChangeLogCommand;
import org.apache.maven.scm.command.changelog.ChangeLogScmResult;
import org.apache.maven.scm.command.changelog.ChangeLogSet;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.codehaus.plexus.util.StringUtils;

public class P4ChangeLogCommand
extends AbstractChangeLogCommand
implements P4Command {
    public static final String command = "Perforce changes command";
    private IClient client;

    @Override
    public void setClient(IClient client) {
        this.client = client;
    }

    protected ChangeLogScmResult executeChangeLogCommand(ScmProviderRepository repo, ScmFileSet fileSet, ScmVersion startVersion, ScmVersion endVersion, String datePattern) throws ScmException {
        return this.executeChangeLogCommand(repo, fileSet, null, null, null, datePattern, startVersion, endVersion);
    }

    protected ChangeLogScmResult executeChangeLogCommand(ScmProviderRepository repo, ScmFileSet fileSet, Date startDate, Date endDate, ScmBranch branch, String datePattern) throws ScmException {
        if (branch != null && StringUtils.isNotEmpty((String)branch.getName())) {
            throw new ScmException("This SCM doesn't support branches.");
        }
        return this.executeChangeLogCommand(repo, fileSet, startDate, endDate, branch, datePattern, null, null);
    }

    protected ChangeLogScmResult executeChangeLogCommand(ScmProviderRepository repo, ScmFileSet fileSet, Date startDate, Date endDate, ScmBranch branch, String datePattern, ScmVersion startVersion, ScmVersion endVersion) throws ScmException {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        if (datePattern != null) {
            dateFormat = new SimpleDateFormat(datePattern);
        }
        StringBuilder filePathSuffix = new StringBuilder();
        if (startDate != null) {
            filePathSuffix.append("@").append(dateFormat.format(startDate)).append(",");
            if (endDate != null) {
                filePathSuffix.append(dateFormat.format(endDate));
            } else {
                filePathSuffix.append("now");
            }
        }
        if (startVersion != null) {
            filePathSuffix.append("@").append(startVersion.getName()).append(",");
            if (endVersion != null) {
                filePathSuffix.append(endVersion.getName());
            } else {
                filePathSuffix.append("now");
            }
        }
        String filePath = fileSet.getBasedir() + "/..." + filePathSuffix.toString();
        List fileSpecs = FileSpecBuilder.makeFileSpecList((String)filePath);
        ArrayList<ChangeSet> changeSets = new ArrayList<ChangeSet>();
        try {
            GetChangelistsOptions getChangelistsOptions = new GetChangelistsOptions();
            IOptionsServer server = (IOptionsServer)this.client.getServer();
            List retChangelistSummaries = server.getChangelists(fileSpecs, getChangelistsOptions);
            for (IChangelistSummary changelistSummary : retChangelistSummaries) {
                IChangelist changelist = server.getChangelist(changelistSummary.getId());
                List files = changelist.getFiles(true);
                ChangeSet changeSet = new ChangeSet();
                changeSet.setAuthor(changelist.getUsername());
                changeSet.setComment(changelist.getDescription().trim());
                changeSet.setDate(changelist.getDate());
                changeSet.setRevision(String.valueOf(changelistSummary.getId()));
                if (files != null) {
                    for (IFileSpec file : files) {
                        ChangeFile changeFile = new ChangeFile(file.getDepotPath().getPathString(), String.valueOf(file.getEndRevision()));
                        changeSet.addFile(changeFile);
                    }
                }
                changeSets.add(changeSet);
            }
        }
        catch (P4JavaException e) {
            throw new ScmException(e.getLocalizedMessage(), (Throwable)e);
        }
        ChangeLogSet cls = new ChangeLogSet(changeSets, null, null);
        cls.setStartVersion(startVersion);
        cls.setEndVersion(endVersion);
        return new ChangeLogScmResult(command, cls);
    }
}

