/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.maven.scm.provider.p4.command.checkin;

import com.perforce.maven.scm.provider.p4.command.P4Command;
import com.perforce.maven.scm.provider.p4.command.checkin.P4CheckInResult;
import com.perforce.maven.scm.provider.p4.util.P4Utils;
import com.perforce.p4java.client.IClient;
import com.perforce.p4java.core.ChangelistStatus;
import com.perforce.p4java.core.IChangelist;
import com.perforce.p4java.core.file.IFileSpec;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.impl.generic.core.Changelist;
import com.perforce.p4java.impl.mapbased.server.Server;
import com.perforce.p4java.option.changelist.SubmitOptions;
import com.perforce.p4java.option.client.ReopenFilesOptions;
import com.perforce.p4java.option.server.OpenedFilesOptions;
import java.util.Date;
import java.util.List;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmVersion;
import org.apache.maven.scm.command.checkin.AbstractCheckInCommand;
import org.apache.maven.scm.command.checkin.CheckInScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;

public class P4CheckInCommand
extends AbstractCheckInCommand
implements P4Command {
    public static final String command = "Perforce submit command";
    private IClient client;

    @Override
    public void setClient(IClient client) {
        this.client = client;
    }

    protected CheckInScmResult executeCheckInCommand(ScmProviderRepository repo, ScmFileSet files, String message, ScmVersion version) throws ScmException {
        P4CheckInResult p4Result = new P4CheckInResult();
        List<IFileSpec> fileSpecs = P4Utils.scmFileSet2P4FileSpecs(files);
        try {
            OpenedFilesOptions openedFilesOptions = new OpenedFilesOptions();
            List retFileSpecs = this.client.openedFiles(fileSpecs, openedFilesOptions);
            if (!retFileSpecs.isEmpty()) {
                Changelist newChangelistImpl = new Changelist(-1, this.client.getName(), this.client.getOwnerName(), ChangelistStatus.NEW, new Date(), message, false, (Server)this.client.getServer());
                IChangelist retChangelist = this.client.createChangelist((IChangelist)newChangelistImpl);
                ReopenFilesOptions reopenFilesOptions = new ReopenFilesOptions();
                reopenFilesOptions.setChangelistId(retChangelist.getId());
                retFileSpecs = this.client.reopenFiles(fileSpecs, reopenFilesOptions);
                if (retChangelist.canRefresh()) {
                    retChangelist.refresh();
                }
                SubmitOptions submitOptions = new SubmitOptions();
                submitOptions.setJobIds(P4Utils.getJobs());
                retFileSpecs = retChangelist.submit(submitOptions);
                p4Result.process(retFileSpecs);
            }
        }
        catch (P4JavaException e) {
            throw new ScmException(e.getLocalizedMessage(), (Throwable)e);
        }
        if (!p4Result.isSuccess()) {
            return new CheckInScmResult(command, "Unable to submit", p4Result.getCommandOutput(), p4Result.isSuccess());
        }
        return new CheckInScmResult(command, p4Result.getCommandResult());
    }
}

