/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.maven.scm.provider.p4.command.checkout;

import com.perforce.maven.scm.provider.p4.command.P4Command;
import com.perforce.maven.scm.provider.p4.command.checkout.P4CheckOutResult;
import com.perforce.maven.scm.provider.p4.util.P4Utils;
import com.perforce.p4java.client.IClient;
import com.perforce.p4java.core.file.IFileSpec;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.option.client.SyncOptions;
import java.util.List;
import org.apache.maven.scm.ScmBranch;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmFileStatus;
import org.apache.maven.scm.ScmTag;
import org.apache.maven.scm.ScmVersion;
import org.apache.maven.scm.command.checkout.AbstractCheckOutCommand;
import org.apache.maven.scm.command.checkout.CheckOutScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;

public class P4CheckOutCommand
extends AbstractCheckOutCommand
implements P4Command {
    public static final String command = "Perforce sync command";
    private IClient client;

    @Override
    public void setClient(IClient client) {
        this.client = client;
    }

    protected CheckOutScmResult executeCheckOutCommand(ScmProviderRepository repo, ScmFileSet files, ScmVersion version, boolean recursive) throws ScmException {
        if (version != null && !(version instanceof ScmTag) && version instanceof ScmBranch) {
            version = null;
        }
        P4CheckOutResult p4Result = new P4CheckOutResult();
        List<IFileSpec> fileSpecs = P4Utils.scmFileSet2P4FileSpecs(files, version);
        try {
            SyncOptions syncOptions = new SyncOptions(false, false, false, false);
            String[] filesList = files.getBasedir().list();
            if (filesList == null || filesList.length == 0) {
                syncOptions.setForceUpdate(true);
            }
            List retFileSpecs = this.client.sync(fileSpecs, syncOptions);
            p4Result.process(retFileSpecs);
            p4Result.removeResultStatusType(ScmFileStatus.DELETED);
        }
        catch (P4JavaException e) {
            throw new ScmException(e.getLocalizedMessage(), (Throwable)e);
        }
        if (!p4Result.isSuccess()) {
            return new CheckOutScmResult(command, "The sync command failed.", p4Result.getCommandOutput(), p4Result.isSuccess());
        }
        return new CheckOutScmResult(command, p4Result.getCommandResult());
    }
}

