/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.maven.scm.provider.p4.command.diff;

import com.perforce.maven.scm.provider.p4.command.P4Command;
import com.perforce.maven.scm.provider.p4.command.diff.P4DiffResult;
import com.perforce.maven.scm.provider.p4.repository.P4ScmProviderRepository;
import com.perforce.p4java.client.IClient;
import com.perforce.p4java.core.file.IFileSpec;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.impl.generic.core.file.FileSpec;
import com.perforce.p4java.option.server.GetFileDiffsOptions;
import com.perforce.p4java.server.IOptionsServer;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmVersion;
import org.apache.maven.scm.command.diff.AbstractDiffCommand;
import org.apache.maven.scm.command.diff.DiffScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.codehaus.plexus.util.StringUtils;

public class P4DiffCommand
extends AbstractDiffCommand
implements P4Command {
    public static final String command = "Perforce diff2 command";
    private IClient client;
    private IOptionsServer server;

    @Override
    public void setClient(IClient client) {
        this.client = client;
        this.server = (IOptionsServer)this.client.getServer();
    }

    protected DiffScmResult executeDiffCommand(ScmProviderRepository repo, ScmFileSet files, ScmVersion startRev, ScmVersion endRev) throws ScmException {
        String start = startRev != null && StringUtils.isNotEmpty((String)startRev.getName()) ? "@" + startRev.getName() : "";
        String end = endRev != null && StringUtils.isNotEmpty((String)endRev.getName()) ? "@" + endRev.getName() : "@now";
        FileSpec fileSpec1 = new FileSpec(files.getBasedir().getAbsolutePath() + "/..." + start);
        FileSpec fileSpec2 = new FileSpec(((P4ScmProviderRepository)repo).getPath() + "/..." + end);
        try {
            GetFileDiffsOptions options = new GetFileDiffsOptions();
            options.setQuiet(true);
            options.setUnifiedDiff(0);
            P4DiffResult p4Result = new P4DiffResult(this.server.getFileDiffs((IFileSpec)fileSpec1, (IFileSpec)fileSpec2, null, options));
            if (!p4Result.isSuccess()) {
                return new DiffScmResult(command, "The diff2 command failed.", p4Result.getFileDiffOutput(), p4Result.isSuccess());
            }
            return new DiffScmResult(command, p4Result.getChangedFiles(), p4Result.getDifferences(), p4Result.getPatch());
        }
        catch (P4JavaException e) {
            throw new ScmException(e.getLocalizedMessage(), (Throwable)e);
        }
    }
}

