/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.maven.scm.provider.p4.command.diff;

import com.perforce.maven.scm.provider.p4.command.P4Result;
import com.perforce.p4java.core.IFileDiff;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.scm.ScmFile;
import org.apache.maven.scm.ScmFileStatus;

public class P4DiffResult
extends P4Result {
    private String fileDiffOutput = "";
    private List<ScmFile> changedFiles = new ArrayList<ScmFile>();
    private Map<String, CharSequence> differences = new HashMap<String, CharSequence>();
    private StringBuffer patch = new StringBuffer();

    public P4DiffResult(List<IFileDiff> fileDiffs) {
        this.processFileDiffs(fileDiffs);
    }

    @Override
    public String processMessage(String message) {
        return null;
    }

    public void processFileDiffs(List<IFileDiff> fileDiffs) {
        if (fileDiffs != null) {
            for (IFileDiff fileDiff : fileDiffs) {
                if (fileDiff == null) continue;
                StringBuilder sb = new StringBuilder();
                if (fileDiff.getStatus() != null) {
                    sb.append("status").append("=").append(fileDiff.getStatus()).append(LINE_SEPARATOR);
                }
                if (fileDiff.getFileType1() != null) {
                    sb.append("fileType1").append("=").append(fileDiff.getFileType1()).append(LINE_SEPARATOR);
                }
                if (fileDiff.getDepotFile1() != null) {
                    sb.append("depotFile1").append("=").append(fileDiff.getDepotFile1()).append(LINE_SEPARATOR);
                }
                if (fileDiff.getRevision1() > -1) {
                    sb.append("revision1").append("=").append(fileDiff.getRevision1()).append(LINE_SEPARATOR);
                }
                if (fileDiff.getFileType2() != null) {
                    sb.append("fileType2").append("=").append(fileDiff.getFileType2()).append(LINE_SEPARATOR);
                }
                if (fileDiff.getDepotFile2() != null) {
                    sb.append("depotFile2").append("=").append(fileDiff.getDepotFile2()).append(LINE_SEPARATOR);
                }
                if (fileDiff.getRevision2() > -1) {
                    sb.append("revision2").append("=").append(fileDiff.getRevision2()).append(LINE_SEPARATOR);
                }
                this.fileDiffOutput = this.fileDiffOutput + sb.toString();
                StringBuilder fileDiffPath = new StringBuilder();
                if (fileDiff.getStatus() == null) continue;
                switch (fileDiff.getStatus()) {
                    case LEFT_ONLY: {
                        fileDiffPath.append(fileDiff.getDepotFile1().toString()).append("#").append(fileDiff.getRevision1()).append(" (").append(fileDiff.getFileType1()).append(")");
                        fileDiffPath.append(" - ");
                        fileDiffPath.append(" <none> ");
                        fileDiffPath.append(" ==== ");
                        fileDiffPath.append(fileDiff.getStatus());
                        break;
                    }
                    case RIGHT_ONLY: {
                        fileDiffPath.append(fileDiff.getDepotFile2().toString()).append("#").append(fileDiff.getRevision2()).append(" (").append(fileDiff.getFileType2()).append(")");
                        fileDiffPath.append(" - ");
                        fileDiffPath.append(" <none> ");
                        fileDiffPath.append(" ==== ");
                        fileDiffPath.append(fileDiff.getStatus());
                        break;
                    }
                    case CONTENT: {
                        fileDiffPath.append(fileDiff.getDepotFile1().toString()).append("#").append(fileDiff.getRevision1()).append(" (").append(fileDiff.getFileType1()).append(")");
                        fileDiffPath.append(" - ");
                        fileDiffPath.append(fileDiff.getDepotFile2().toString()).append("#").append(fileDiff.getRevision2()).append(" (").append(fileDiff.getFileType2()).append(")");
                        fileDiffPath.append(" ==== ");
                        fileDiffPath.append(fileDiff.getStatus());
                        break;
                    }
                    case IDENTICAL: {
                        fileDiffPath.append(fileDiff.getDepotFile1().toString()).append("#").append(fileDiff.getRevision1()).append(" (").append(fileDiff.getFileType1()).append(")");
                        fileDiffPath.append(" - ");
                        fileDiffPath.append(fileDiff.getDepotFile2().toString()).append("#").append(fileDiff.getRevision2()).append(" (").append(fileDiff.getFileType2()).append(")");
                        fileDiffPath.append(" ==== ");
                        fileDiffPath.append(fileDiff.getStatus());
                        break;
                    }
                }
                this.changedFiles.add(new ScmFile(fileDiffPath.toString(), ScmFileStatus.MODIFIED));
                this.differences.put(fileDiffPath.toString(), fileDiff.getStatus().toString());
                this.patch.append(fileDiffPath.toString()).append(LINE_SEPARATOR);
            }
        }
    }

    public String getFileDiffOutput() {
        return this.fileDiffOutput;
    }

    public List<ScmFile> getChangedFiles() {
        return this.changedFiles;
    }

    public Map<String, CharSequence> getDifferences() {
        return this.differences;
    }

    public String getPatch() {
        return this.patch.toString();
    }
}

