/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.maven.scm.provider.p4.command.edit;

import com.perforce.maven.scm.provider.p4.command.P4Command;
import com.perforce.maven.scm.provider.p4.command.edit.P4EditResult;
import com.perforce.maven.scm.provider.p4.util.P4Utils;
import com.perforce.p4java.client.IClient;
import com.perforce.p4java.core.file.IFileSpec;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.option.client.EditFilesOptions;
import java.util.List;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.command.edit.AbstractEditCommand;
import org.apache.maven.scm.command.edit.EditScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;

public class P4EditCommand
extends AbstractEditCommand
implements P4Command {
    public static final String command = "Perforce edit command";
    private IClient client;

    @Override
    public void setClient(IClient client) {
        this.client = client;
    }

    protected ScmResult executeEditCommand(ScmProviderRepository repo, ScmFileSet files) throws ScmException {
        P4EditResult p4Result = new P4EditResult();
        List<IFileSpec> fileSpecs = P4Utils.scmFileSet2P4FileSpecs(files);
        if (!fileSpecs.isEmpty()) {
            try {
                EditFilesOptions editFilesOptions = new EditFilesOptions();
                List retFileSpecs = this.client.editFiles(fileSpecs, editFilesOptions);
                p4Result.process(retFileSpecs);
            }
            catch (P4JavaException e) {
                throw new ScmException(e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return new EditScmResult(command, p4Result.isSuccess() ? "Edit successful" : "Unable to edit", p4Result.getCommandOutput(), p4Result.isSuccess());
    }
}

