/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.maven.scm.provider.p4.command.export;

import com.perforce.maven.scm.provider.p4.command.P4Command;
import com.perforce.maven.scm.provider.p4.command.checkout.P4CheckOutCommand;
import com.perforce.p4java.client.IClient;
import org.apache.maven.scm.CommandParameter;
import org.apache.maven.scm.CommandParameters;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmVersion;
import org.apache.maven.scm.command.checkout.CheckOutScmResult;
import org.apache.maven.scm.command.export.AbstractExportCommand;
import org.apache.maven.scm.command.export.ExportScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;

public class P4ExportCommand
extends AbstractExportCommand
implements P4Command {
    public static final String command = "Perforce sync command";
    private IClient client;

    @Override
    public void setClient(IClient client) {
        this.client = client;
    }

    protected ExportScmResult executeExportCommand(ScmProviderRepository repo, ScmFileSet files, ScmVersion scmVersion, String outputDirectory) throws ScmException {
        P4CheckOutCommand command = new P4CheckOutCommand();
        command.setLogger(this.getLogger());
        command.setClient(this.client);
        CommandParameters params = new CommandParameters();
        params.setScmVersion(CommandParameter.SCM_VERSION, scmVersion);
        CheckOutScmResult checkOutScmResult = (CheckOutScmResult)command.execute(repo, files, params);
        if (!checkOutScmResult.isSuccess()) {
            return new ExportScmResult(checkOutScmResult.getCommandLine(), checkOutScmResult.getProviderMessage(), checkOutScmResult.getCommandOutput(), false);
        }
        return new ExportScmResult(checkOutScmResult.getCommandLine(), checkOutScmResult.getProviderMessage(), checkOutScmResult.getCommandOutput(), true);
    }
}

