/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.maven.scm.provider.p4.command.info;

import com.perforce.maven.scm.provider.p4.command.P4Command;
import com.perforce.maven.scm.provider.p4.util.P4Utils;
import com.perforce.p4java.client.IClient;
import com.perforce.p4java.core.IChangelistSummary;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import org.apache.maven.scm.CommandParameter;
import org.apache.maven.scm.CommandParameters;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmVersion;
import org.apache.maven.scm.command.AbstractCommand;
import org.apache.maven.scm.command.info.InfoItem;
import org.apache.maven.scm.command.info.InfoScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;

public class P4InfoCommand
extends AbstractCommand
implements P4Command {
    public static final String command = "Perforce info command";
    private IClient client;

    @Override
    public void setClient(IClient client) {
        this.client = client;
    }

    protected InfoScmResult executeCommand(ScmProviderRepository repo, ScmFileSet files, CommandParameters params) throws ScmException {
        String datePattern = "yyyy/MM/dd HH:mm:ss";
        if (params != null) {
            datePattern = params.getString(CommandParameter.CHANGELOG_DATE_PATTERN, datePattern);
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(datePattern);
        ArrayList<InfoItem> infoItems = new ArrayList<InfoItem>();
        InfoItem infoItem = new InfoItem();
        ScmVersion scmVersion = null;
        if (params != null) {
            scmVersion = params.getScmVersion(CommandParameter.SCM_VERSION, null);
        }
        IChangelistSummary cl = P4Utils.getLatestChangelist(this.client, files.getBasedir(), scmVersion, true);
        infoItem.setRevision(Long.toString(cl.getId()));
        infoItem.setLastChangedRevision(Long.toString(cl.getId()));
        infoItem.setLastChangedAuthor(cl.getUsername());
        infoItem.setLastChangedDate(dateFormat.format(cl.getDate()));
        cl = P4Utils.getLatestChangelist(this.client, files.getBasedir(), scmVersion, false);
        if (cl != null) {
            infoItem.setLastChangedRevision(Long.toString(cl.getId()));
            infoItem.setLastChangedAuthor(cl.getUsername());
            infoItem.setLastChangedDate(dateFormat.format(cl.getDate()));
        }
        infoItems.add(infoItem);
        InfoScmResult result = new InfoScmResult(command, infoItems);
        return result;
    }
}

