/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.maven.scm.provider.p4.command.list;

import com.perforce.maven.scm.provider.p4.command.P4Command;
import com.perforce.maven.scm.provider.p4.command.list.P4ListResult;
import com.perforce.maven.scm.provider.p4.util.P4Utils;
import com.perforce.p4java.client.IClient;
import com.perforce.p4java.core.file.IFileSpec;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.option.server.GetDepotFilesOptions;
import com.perforce.p4java.server.IOptionsServer;
import java.util.List;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmVersion;
import org.apache.maven.scm.command.list.AbstractListCommand;
import org.apache.maven.scm.command.list.ListScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;

public class P4ListCommand
extends AbstractListCommand
implements P4Command {
    public static final String command = "Perforce files command";
    private IClient client;

    @Override
    public void setClient(IClient client) {
        this.client = client;
    }

    protected ListScmResult executeListCommand(ScmProviderRepository repo, ScmFileSet files, boolean recursive, ScmVersion scmVersion) throws ScmException {
        P4ListResult p4Result = new P4ListResult();
        List<IFileSpec> fileSpecs = P4Utils.scmFileSet2P4FileSpecs(files);
        if (!fileSpecs.isEmpty()) {
            try {
                GetDepotFilesOptions getDepotFilesOptions = new GetDepotFilesOptions();
                IOptionsServer server = (IOptionsServer)this.client.getServer();
                List retFileSpecs = server.getDepotFiles(fileSpecs, getDepotFilesOptions);
                p4Result.process(retFileSpecs);
            }
            catch (P4JavaException e) {
                throw new ScmException(e.getLocalizedMessage(), (Throwable)e);
            }
        }
        if (!p4Result.isSuccess()) {
            return new ListScmResult(command, "The files command failed.", p4Result.getCommandOutput(), p4Result.isSuccess());
        }
        return new ListScmResult(command, p4Result.getCommandResult());
    }
}

