/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.maven.scm.provider.p4.command.remove;

import com.perforce.maven.scm.provider.p4.command.P4Command;
import com.perforce.maven.scm.provider.p4.command.remove.P4RemoveResult;
import com.perforce.maven.scm.provider.p4.util.P4Utils;
import com.perforce.p4java.client.IClient;
import com.perforce.p4java.core.file.IFileSpec;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.option.client.DeleteFilesOptions;
import java.util.List;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFile;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.command.remove.AbstractRemoveCommand;
import org.apache.maven.scm.command.remove.RemoveScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;

public class P4RemoveCommand
extends AbstractRemoveCommand
implements P4Command {
    public static final String command = "Perforce delete command";
    private IClient client;

    @Override
    public void setClient(IClient client) {
        this.client = client;
    }

    protected ScmResult executeRemoveCommand(ScmProviderRepository repo, ScmFileSet files, String message) throws ScmException {
        P4RemoveResult p4Result = new P4RemoveResult();
        List<IFileSpec> fileSpecs = P4Utils.scmFileSet2P4FileSpecsWithNoP4WildCard(files);
        try {
            if (!fileSpecs.isEmpty()) {
                DeleteFilesOptions options = new DeleteFilesOptions();
                List retFileSpecs = this.client.deleteFiles(fileSpecs, options);
                p4Result.process(retFileSpecs);
                p4Result.processRemovals(retFileSpecs);
            }
        }
        catch (P4JavaException e) {
            throw new ScmException(e.getLocalizedMessage(), (Throwable)e);
        }
        List<ScmFile> removals = p4Result.getRemovals();
        return new RemoveScmResult(command, removals);
    }
}

