/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.maven.scm.provider.p4.command.status;

import com.perforce.maven.scm.provider.p4.command.P4Command;
import com.perforce.maven.scm.provider.p4.command.status.P4StatusResult;
import com.perforce.maven.scm.provider.p4.util.P4Utils;
import com.perforce.p4java.client.IClient;
import com.perforce.p4java.core.file.IFileSpec;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.option.server.OpenedFilesOptions;
import java.util.List;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.command.status.AbstractStatusCommand;
import org.apache.maven.scm.command.status.StatusScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;

public class P4StatusCommand
extends AbstractStatusCommand
implements P4Command {
    public static final String command = "Perforce opened command";
    private IClient client;

    @Override
    public void setClient(IClient client) {
        this.client = client;
    }

    protected StatusScmResult executeStatusCommand(ScmProviderRepository repo, ScmFileSet files) throws ScmException {
        P4StatusResult p4Result = new P4StatusResult();
        List<IFileSpec> fileSpecs = P4Utils.scmFileSet2P4FileSpecs(files);
        if (!fileSpecs.isEmpty()) {
            try {
                OpenedFilesOptions openedFilesOptions = new OpenedFilesOptions();
                List retFileSpecs = this.client.openedFiles(fileSpecs, openedFilesOptions);
                p4Result.process(retFileSpecs);
            }
            catch (P4JavaException e) {
                throw new ScmException(e.getLocalizedMessage(), (Throwable)e);
            }
        }
        if (!p4Result.isSuccess()) {
            return new StatusScmResult(command, "The opened command failed.", p4Result.getCommandOutput(), p4Result.isSuccess());
        }
        return new StatusScmResult(command, p4Result.getCommandResult());
    }
}

