/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.maven.scm.provider.p4.command.tag;

import com.perforce.maven.scm.provider.p4.command.P4Command;
import com.perforce.maven.scm.provider.p4.command.tag.P4TagResult;
import com.perforce.maven.scm.provider.p4.repository.P4ScmProviderRepository;
import com.perforce.maven.scm.provider.p4.util.P4Utils;
import com.perforce.p4java.client.IClient;
import com.perforce.p4java.core.ILabel;
import com.perforce.p4java.core.ILabelMapping;
import com.perforce.p4java.core.IMapEntry;
import com.perforce.p4java.core.ViewMap;
import com.perforce.p4java.core.file.IFileSpec;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.impl.generic.core.Label;
import com.perforce.p4java.option.client.LabelSyncOptions;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFile;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmFileStatus;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.ScmTagParameters;
import org.apache.maven.scm.command.tag.AbstractTagCommand;
import org.apache.maven.scm.command.tag.TagScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;

public class P4TagCommand
extends AbstractTagCommand
implements P4Command {
    public static final String command = "Perforce label command";
    private IClient client;

    @Override
    public void setClient(IClient client) {
        this.client = client;
    }

    protected ScmResult executeTagCommand(ScmProviderRepository repo, ScmFileSet files, String tag, String message) throws ScmException {
        return this.executeTagCommand(repo, files, tag, new ScmTagParameters(message));
    }

    protected ScmResult executeTagCommand(ScmProviderRepository repo, ScmFileSet files, String tag, ScmTagParameters scmTagParameters) throws ScmException {
        P4ScmProviderRepository p4Repo = (P4ScmProviderRepository)repo;
        try {
            if (!files.getFileList().isEmpty()) {
                return this.labelWithLabelSync(p4Repo, files, tag);
            }
            return this.labelWithLatestChangelist(p4Repo, files, tag);
        }
        catch (P4JavaException e) {
            throw new ScmException(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    private ViewMap<ILabelMapping> getViewMap(P4ScmProviderRepository p4Repo) {
        String canRepoPath = P4Utils.getCanonicalRepoPath(p4Repo.getPath());
        ViewMap viewMap = new ViewMap();
        String[] viewPaths = new String[]{canRepoPath};
        for (int i = 0; i < viewPaths.length; ++i) {
            Label.LabelMapping entry = new Label.LabelMapping(i + 1, viewPaths[i]);
            viewMap.addEntry((IMapEntry)entry);
        }
        return viewMap;
    }

    private TagScmResult labelWithLabelSync(P4ScmProviderRepository p4Repo, ScmFileSet files, String tag) throws ScmException, P4JavaException {
        String retStatusMessage = "";
        P4TagResult p4Result = new P4TagResult();
        List<IFileSpec> fileSpecs = P4Utils.scmFileSet2P4FileSpecs(files);
        ViewMap<ILabelMapping> viewMap = this.getViewMap(p4Repo);
        ILabel retLabel = this.client.getServer().getLabel(tag);
        if (retLabel != null) {
            if (!StringUtils.isBlank((String)this.client.getOwnerName())) {
                retLabel.setOwnerName(this.client.getOwnerName());
            }
            retLabel.setLastUpdate(new Date());
            retLabel.setLocked(false);
            if (viewMap != null && viewMap.getSize() > 0) {
                retLabel.setViewMapping(viewMap);
            }
            retStatusMessage = this.client.getServer().updateLabel(retLabel);
        } else {
            Date lastAccess = null;
            Date lastUpdate = null;
            retLabel = new Label(tag, this.client.getOwnerName(), lastAccess, lastUpdate, null, null, false, viewMap);
            retStatusMessage = this.client.getServer().createLabel(retLabel);
        }
        retLabel = this.client.getServer().getLabel(tag);
        if (retLabel != null) {
            p4Result.setSuccess(true);
            LabelSyncOptions labelSyncOptions = new LabelSyncOptions();
            List retFileSpecs = this.client.labelSync(fileSpecs, tag, labelSyncOptions);
            p4Result.processTagged(retFileSpecs);
            retLabel.setLocked(P4Utils.getSettings().isLockTag());
            this.client.getServer().updateLabel(retLabel);
        }
        if (!p4Result.isSuccess()) {
            return new TagScmResult(command, "Tag failed", retStatusMessage, false);
        }
        return new TagScmResult(command, p4Result.getTagged());
    }

    private TagScmResult labelWithLatestChangelist(P4ScmProviderRepository p4Repo, ScmFileSet files, String tag) throws ScmException, P4JavaException {
        ViewMap<ILabelMapping> viewMap = this.getViewMap(p4Repo);
        String revisionSpec = this.retrieveRevisionSpec(files.getBasedir());
        ILabel label = this.client.getServer().getLabel(tag);
        if (label != null && !P4Utils.getSettings().isAllowingTagUpdate()) {
            throw new ScmException("Unable to create new tag since it is already created. ");
        }
        label = new Label(tag, this.client.getOwnerName(), null, null, null, revisionSpec, P4Utils.getSettings().isLockTag(), viewMap);
        this.client.getServer().createLabel(label);
        ArrayList<ScmFile> scmFileList = new ArrayList<ScmFile>();
        List fileList = null;
        try {
            fileList = FileUtils.getFiles((File)files.getBasedir(), null, null);
            for (File f : fileList) {
                scmFileList.add(new ScmFile(f.getPath(), ScmFileStatus.TAGGED));
            }
        }
        catch (IOException e) {
            throw new ScmException("Error while executing command.", (Throwable)e);
        }
        return new TagScmResult(command, scmFileList);
    }

    private String retrieveRevisionSpec(File basedir) throws ScmException {
        return "@" + P4Utils.getLatestChangelist(this.client, basedir, null, false).getId();
    }
}

