/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.maven.scm.provider.p4.command.unedit;

import com.perforce.maven.scm.provider.p4.command.P4Command;
import com.perforce.maven.scm.provider.p4.command.unedit.P4UnEditResult;
import com.perforce.maven.scm.provider.p4.util.P4Utils;
import com.perforce.p4java.client.IClient;
import com.perforce.p4java.core.file.IFileSpec;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.option.client.RevertFilesOptions;
import java.util.List;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.command.unedit.AbstractUnEditCommand;
import org.apache.maven.scm.command.unedit.UnEditScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;

public class P4UnEditCommand
extends AbstractUnEditCommand
implements P4Command {
    public static final String command = "Perforce revert command";
    private IClient client;

    @Override
    public void setClient(IClient client) {
        this.client = client;
    }

    protected ScmResult executeUnEditCommand(ScmProviderRepository repo, ScmFileSet files) throws ScmException {
        P4UnEditResult p4Result = new P4UnEditResult();
        List<IFileSpec> fileSpecs = P4Utils.scmFileSet2P4FileSpecs(files);
        if (!fileSpecs.isEmpty()) {
            try {
                RevertFilesOptions revertFilesOptions = new RevertFilesOptions();
                List retFileSpecs = this.client.revertFiles(fileSpecs, revertFilesOptions);
                p4Result.process(retFileSpecs);
            }
            catch (P4JavaException e) {
                throw new ScmException(e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return new UnEditScmResult(command, p4Result.isSuccess() ? "Revert successful" : "Unable to revert", p4Result.getCommandOutput(), p4Result.isSuccess());
    }
}

