/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.maven.scm.provider.p4.command.update;

import com.perforce.maven.scm.provider.p4.command.P4Command;
import com.perforce.maven.scm.provider.p4.command.changelog.P4ChangeLogCommand;
import com.perforce.maven.scm.provider.p4.command.checkout.P4CheckOutCommand;
import com.perforce.p4java.client.IClient;
import com.perforce.p4java.core.IChangelist;
import com.perforce.p4java.core.IChangelistSummary;
import com.perforce.p4java.core.file.FileSpecBuilder;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.option.server.GetChangelistsOptions;
import com.perforce.p4java.server.IOptionsServer;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.scm.CommandParameter;
import org.apache.maven.scm.CommandParameters;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.ScmVersion;
import org.apache.maven.scm.command.changelog.ChangeLogCommand;
import org.apache.maven.scm.command.checkout.CheckOutScmResult;
import org.apache.maven.scm.command.update.AbstractUpdateCommand;
import org.apache.maven.scm.command.update.UpdateScmResult;
import org.apache.maven.scm.command.update.UpdateScmResultWithRevision;
import org.apache.maven.scm.provider.ScmProviderRepository;

public class P4UpdateCommand
extends AbstractUpdateCommand
implements P4Command {
    public static final String command = "Perforce sync command";
    private IClient client;

    @Override
    public void setClient(IClient client) {
        this.client = client;
    }

    protected UpdateScmResult executeUpdateCommand(ScmProviderRepository repo, ScmFileSet files, ScmVersion scmVersion) throws ScmException {
        P4CheckOutCommand command = new P4CheckOutCommand();
        command.setLogger(this.getLogger());
        command.setClient(this.client);
        CommandParameters params = new CommandParameters();
        params.setScmVersion(CommandParameter.SCM_VERSION, scmVersion);
        CheckOutScmResult checkOutScmResult = (CheckOutScmResult)command.execute(repo, files, params);
        if (!checkOutScmResult.isSuccess()) {
            return new UpdateScmResult(checkOutScmResult.getCommandLine(), checkOutScmResult.getProviderMessage(), checkOutScmResult.getCommandOutput(), false);
        }
        int revision = 0;
        try {
            Iterator i$;
            GetChangelistsOptions getChangelistsOptions = new GetChangelistsOptions();
            getChangelistsOptions.setMaxMostRecent(1);
            getChangelistsOptions.setType(IChangelist.Type.SUBMITTED);
            String fileSpec = "//" + this.client.getName() + "/...#have";
            List fileSpecs = FileSpecBuilder.makeFileSpecList((String)fileSpec);
            IOptionsServer server = (IOptionsServer)this.client.getServer();
            List retChangelistSummaries = server.getChangelists(fileSpecs, getChangelistsOptions);
            if (retChangelistSummaries != null && (i$ = retChangelistSummaries.iterator()).hasNext()) {
                IChangelistSummary changelistSummary = (IChangelistSummary)i$.next();
                revision = changelistSummary.getId();
            }
        }
        catch (P4JavaException e) {
            throw new ScmException(e.getLocalizedMessage(), (Throwable)e);
        }
        return new UpdateScmResultWithRevision(checkOutScmResult.getCheckedOutFiles(), null, String.valueOf(revision), (ScmResult)checkOutScmResult);
    }

    protected ChangeLogCommand getChangeLogCommand() {
        P4ChangeLogCommand command = new P4ChangeLogCommand();
        command.setLogger(this.getLogger());
        command.setClient(this.client);
        return command;
    }
}

