/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.maven.scm.provider.p4.manager;

import com.perforce.maven.scm.provider.p4.manager.DefaultP4ServerManager;
import com.perforce.maven.scm.provider.p4.manager.P4ClientManager;
import com.perforce.maven.scm.provider.p4.manager.P4ClientThreadLocal;
import com.perforce.maven.scm.provider.p4.manager.P4ServerManager;
import com.perforce.maven.scm.provider.p4.repository.P4ScmProviderRepository;
import com.perforce.maven.scm.provider.p4.util.P4Utils;
import com.perforce.p4java.client.IClient;
import com.perforce.p4java.client.IClientSummary;
import com.perforce.p4java.client.IClientViewMapping;
import com.perforce.p4java.core.IMapEntry;
import com.perforce.p4java.core.file.FileSpecBuilder;
import com.perforce.p4java.core.file.FileSpecOpStatus;
import com.perforce.p4java.core.file.IFileSpec;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.impl.generic.client.ClientView;
import com.perforce.p4java.impl.mapbased.client.Client;
import com.perforce.p4java.server.IServer;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.io.FileUtils;
import org.apache.maven.scm.ScmException;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Disposable;
import org.codehaus.plexus.util.StringUtils;

public class DefaultP4ClientManager
extends AbstractLogEnabled
implements P4ClientManager,
Disposable {
    private P4ServerManager serverManager;
    private Map<String, InternalClient> clients = new ConcurrentHashMap<String, InternalClient>();

    public void dispose() {
        for (InternalClient internalClient : this.clients.values()) {
            if (!internalClient.getRemoveWhenDone()) continue;
            IClient client = internalClient.getClient();
            try {
                client.getServer().deleteClient(client.getName(), false);
                client.getServer().disconnect();
            }
            catch (P4JavaException e) {
                this.getLogger().error(e.getLocalizedMessage());
            }
        }
        this.clients.clear();
    }

    @Override
    public IClient getClient(P4ScmProviderRepository repo, File rootDir) throws ScmException {
        IClient client = this.getClient(repo, rootDir, null);
        P4ClientThreadLocal.set(client);
        return client;
    }

    @Override
    public IClient getClient(P4ScmProviderRepository repo, File rootDir, String clientName) throws ScmException {
        IClient client = null;
        try {
            InternalClient internalClient;
            if (StringUtils.isBlank((String)clientName) && (clientName = this.discoverClientName(repo, rootDir)) == null) {
                clientName = this.generateClientName(repo, rootDir);
            }
            if ((internalClient = this.clients.get(this.getClientKey(repo, clientName, rootDir))) != null && !this.isValidClient(client = internalClient.getClient())) {
                this.getLogger().warn("Staled cached client, creating new one ...");
                this.clients.remove(this.getClientKey(repo, clientName, rootDir));
                client = null;
            }
            if (client == null) {
                boolean removeWhenDone = false;
                IServer server = this.serverManager.createServer(repo);
                client = server.getClient(clientName);
                if (client == null) {
                    client = this.createNewClient(server, repo, clientName, rootDir);
                }
                if (StringUtils.isBlank((String)client.getRoot()) || "null".equals(client.getRoot())) {
                    client.setRoot(rootDir.getAbsolutePath());
                    client.update();
                }
                if (client.getName().equals(this.generateClientName(repo, rootDir))) {
                    removeWhenDone = true;
                }
                this.adjustClientSpecIfRepoPathIsNotConfigure(client, repo);
                this.clients.put(this.getClientKey(repo, clientName, rootDir), new InternalClient(client, removeWhenDone));
            }
            client.getServer().setCurrentClient(client);
        }
        catch (Exception e) {
            throw new ScmException(e.getLocalizedMessage(), (Throwable)e);
        }
        return client;
    }

    private boolean isValidClient(IClient client) {
        return DefaultP4ServerManager.isValidServer(client.getServer());
    }

    private void adjustClientSpecIfRepoPathIsNotConfigure(IClient client, P4ScmProviderRepository repo) throws P4JavaException {
        ClientView clientView = client.getClientView();
        if (clientView == null) {
            clientView = new ClientView();
        }
        ClientView.ClientViewMapping clientViewMapping = this.createClientViewMapping(repo, client.getName());
        List list = clientView.getEntryList();
        boolean exists = false;
        if (list != null) {
            for (IClientViewMapping map : list) {
                if (!map.getDepotSpec().equals(clientViewMapping.getDepotSpec()) || !map.getClient().equals(clientViewMapping.getClient())) continue;
                exists = true;
                break;
            }
        }
        if (!exists) {
            this.getLogger().warn("Auto adjust client view since it does not have repo path: " + repo.getPath() + " configured");
            clientView.addEntry((IMapEntry)clientViewMapping);
            client.setClientView(clientView);
            if (client.canUpdate()) {
                client.update();
            }
            if (client.canRefresh()) {
                client.refresh();
            }
        }
    }

    private IClient createNewClient(IServer server, P4ScmProviderRepository repo, String clientName, File basedir) throws P4JavaException, UnknownHostException {
        ClientView.ClientViewMapping clientViewMapping = this.createClientViewMapping(repo, clientName);
        ClientView clientView = new ClientView();
        clientView.addEntry((IMapEntry)clientViewMapping);
        Client newClient = new Client(clientName, null, null, "Created by P4Maven", InetAddress.getLocalHost().getHostName(), repo.getUser(), basedir.getAbsolutePath(), null, null, null, null, server, clientView);
        server.createClient((IClient)newClient);
        return server.getClient(clientName);
    }

    private String getClientKey(P4ScmProviderRepository repo, String clientName, File rootDir) {
        return repo.getP4Port() + ":" + clientName + ":" + rootDir.getAbsolutePath();
    }

    private String generateClientName(P4ScmProviderRepository repo, File basedir) {
        String username = repo.getUser();
        String hostname = repo.getHost();
        String path = null;
        try {
            hostname = InetAddress.getLocalHost().getHostName();
            path = P4Utils.encodeWildcards(basedir.getCanonicalPath().replaceAll("[/ ~]", "-").replaceAll(",", ""));
        }
        catch (IOException e) {
            this.getLogger().error(e.getMessage(), (Throwable)e);
        }
        String clientName = username + "-" + hostname + "-MavenSCM-" + path + "-" + StringUtils.replace((String)repo.getPath(), (char)'/', (char)'\\');
        try {
            return username + "-" + hostname + "-p4maven-" + DefaultP4ClientManager.toHexString(MessageDigest.getInstance("SHA1").digest(clientName.getBytes()));
        }
        catch (NoSuchAlgorithmException e) {
            return clientName;
        }
    }

    public static String toHexString(byte[] bytes) {
        char[] hexArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = hexArray[v / 16];
            hexChars[j * 2 + 1] = hexArray[v % 16];
        }
        return new String(hexChars);
    }

    private ClientView.ClientViewMapping createClientViewMapping(P4ScmProviderRepository repo, String clientName) {
        String viewPath = P4Utils.getCanonicalRepoPath(repo.getPath());
        return new ClientView.ClientViewMapping(0, viewPath, "//" + clientName + "/...");
    }

    @Override
    public String discoverClientName(P4ScmProviderRepository repo, File baseDir) throws ScmException {
        IClient client = null;
        try {
            client = P4ClientThreadLocal.get();
            if (client != null && this.isClientMatched(client, repo, baseDir)) {
                return client.getName();
            }
            if (P4Utils.getSettings().getClientName() != null) {
                return P4Utils.getSettings().getClientName();
            }
            IServer server = this.serverManager.getServer(repo);
            String queryString = null;
            if (P4Utils.getSettings().isStrictClientDiscovery()) {
                // empty if block
            }
            List clientInfos = server.getClients(repo.getUser(), queryString, Integer.MAX_VALUE);
            String currentHostName = InetAddress.getLocalHost().getHostName();
            for (IClientSummary clientInfo : clientInfos) {
                String[] tokens;
                String p4ClientHostName;
                if (P4Utils.getSettings().isStrictClientDiscovery() && (StringUtils.isBlank((String)(p4ClientHostName = clientInfo.getHostName())) || !currentHostName.equals(p4ClientHostName) && !(tokens = StringUtils.split((String)p4ClientHostName, (String)"."))[0].equals(currentHostName)) || !this.isClientMatched(client = server.getClient(clientInfo), repo, baseDir)) continue;
                return client.getName();
            }
        }
        catch (Exception e) {
            throw new ScmException("Unable to discover client", (Throwable)e);
        }
        return null;
    }

    private boolean isClientMatched(IClient client, P4ScmProviderRepository repo, File baseDir) throws P4JavaException, IOException {
        IServer server = client.getServer();
        if (DefaultP4ClientManager.filePathEquals(baseDir, new File(client.getRoot()))) {
            if (this.clientHasTheMatchingDepotPath(client, repo)) {
                return true;
            }
        } else {
            File clientRootDir = new File(client.getRoot());
            if (clientRootDir.isDirectory() && FileUtils.directoryContains((File)clientRootDir, (File)baseDir)) {
                server.setCurrentClient(client);
                File currentPom = new File(baseDir, "pom.xml");
                if (currentPom.exists()) {
                    List remoteFiles = server.getDepotFiles(client.where(FileSpecBuilder.makeFileSpecList((String)currentPom.getCanonicalPath())), false);
                    for (IFileSpec fileSpec : remoteFiles) {
                        if (fileSpec.getOpStatus() != FileSpecOpStatus.VALID || !fileSpec.getDepotPath().getPathString().equals(repo.getPath() + "/pom.xml")) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean clientHasTheMatchingDepotPath(IClient client, P4ScmProviderRepository repo) {
        boolean found = false;
        for (IClientViewMapping clientViewMapping : client.getClientView().getEntryList()) {
            if (!clientViewMapping.getLeft().startsWith(repo.getPath() + "/...")) continue;
            found = true;
            break;
        }
        return found;
    }

    private static boolean filePathEquals(File file1, File file2) throws IOException {
        if (file1 == null) {
            throw new IllegalArgumentException("file must not be null");
        }
        if (file2 == null) {
            throw new IllegalArgumentException("file must not be null");
        }
        String canonicalPath1 = file1.getCanonicalPath();
        String canonicalPath2 = file2.getCanonicalPath();
        return canonicalPath1.equals(canonicalPath2);
    }

    private class InternalClient {
        private final IClient client;
        private final boolean removeWhenDone;

        public IClient getClient() {
            return this.client;
        }

        public boolean getRemoveWhenDone() {
            return this.removeWhenDone;
        }

        public InternalClient(IClient client, boolean removeWhenDone) {
            this.client = client;
            this.removeWhenDone = new Boolean(removeWhenDone);
        }
    }
}

