/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.maven.scm.provider.p4.manager;

import com.perforce.maven.scm.provider.p4.manager.P4ServerManager;
import com.perforce.maven.scm.provider.p4.repository.P4ScmProviderRepository;
import com.perforce.maven.scm.provider.p4.util.P4Utils;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.impl.generic.sys.ISystemFileCommandsHelper;
import com.perforce.p4java.impl.mapbased.rpc.sys.helper.RpcSystemFileCommandsHelper;
import com.perforce.p4java.option.UsageOptions;
import com.perforce.p4java.option.server.LoginOptions;
import com.perforce.p4java.option.server.TrustOptions;
import com.perforce.p4java.server.IOptionsServer;
import com.perforce.p4java.server.IServer;
import com.perforce.p4java.server.ServerFactory;
import com.perforce.p4java.server.callback.ICommandCallback;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.maven.scm.ScmException;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Disposable;
import org.codehaus.plexus.util.StringUtils;

public class DefaultP4ServerManager
extends AbstractLogEnabled
implements P4ServerManager,
Disposable {
    private Map<String, IServer> servers = new ConcurrentHashMap<String, IServer>();

    public void dispose() {
        for (IServer server : this.servers.values()) {
            try {
                server.disconnect();
            }
            catch (P4JavaException e) {
                this.getLogger().error(e.getLocalizedMessage());
            }
        }
        this.servers.clear();
    }

    @Override
    public IServer getServer(P4ScmProviderRepository repo) throws ScmException {
        IServer server = this.servers.get(repo.getP4Port());
        if (server != null && !DefaultP4ServerManager.isValidServer(server)) {
            this.getLogger().warn("Cached server instance is invalid, will try a new one");
            this.disconnectQuietly(server);
            this.servers.remove(repo.getP4Port());
            server = null;
        }
        if (server == null) {
            server = this.createServer(repo);
            this.servers.put(repo.getP4Port(), server);
        }
        return server;
    }

    public static boolean isValidServer(IServer server) {
        if (P4Utils.getSettings().isCheckStaledConnection()) {
            if (!server.isConnected()) {
                return false;
            }
            try {
                server.getUser(server.getUserName());
            }
            catch (P4JavaException e) {
                return false;
            }
        }
        return true;
    }

    public IOptionsServer createServer(P4ScmProviderRepository repo) throws ScmException {
        IOptionsServer server = null;
        try {
            ServerFactory.setRpcFileSystemHelper((ISystemFileCommandsHelper)new RpcSystemFileCommandsHelper());
            Properties p4ServerProperties = null;
            UsageOptions p4ServerOptions = null;
            server = ServerFactory.getOptionsServer((String)DefaultP4ServerManager.getUrl(repo.getP4Port()), p4ServerProperties, p4ServerOptions);
            if (DefaultP4ServerManager.isSsl(repo.getP4Port())) {
                server.addTrust(new TrustOptions().setAutoAccept(true));
            }
            server.registerCallback(new ICommandCallback(){

                public void receivedServerMessage(int key, int genericCode, int severityCode, String message) {
                    if (severityCode == 2) {
                        DefaultP4ServerManager.this.getLogger().warn(message);
                    } else if (DefaultP4ServerManager.this.getLogger().isDebugEnabled()) {
                        DefaultP4ServerManager.this.getLogger().debug(message);
                    } else if (P4Utils.getSettings().isVerbose()) {
                        System.out.println(message);
                    }
                }

                public void receivedServerInfoLine(int key, String infoLine) {
                    if (DefaultP4ServerManager.this.getLogger().isDebugEnabled()) {
                        DefaultP4ServerManager.this.getLogger().debug(infoLine);
                    } else if (P4Utils.getSettings().isVerbose()) {
                        System.out.println(infoLine);
                    }
                }

                public void receivedServerErrorLine(int key, String errorLine) {
                    if (DefaultP4ServerManager.this.getLogger().isErrorEnabled()) {
                        DefaultP4ServerManager.this.getLogger().error(errorLine);
                    } else if (P4Utils.getSettings().isVerbose()) {
                        System.out.println(errorLine);
                    }
                }

                public void issuingServerCommand(int key, String command) {
                    if (DefaultP4ServerManager.this.getLogger().isDebugEnabled()) {
                        DefaultP4ServerManager.this.getLogger().debug(command);
                    } else if (P4Utils.getSettings().isVerbose()) {
                        System.out.println(command);
                    }
                }

                public void completedServerCommand(int key, long millisecsTaken) {
                    if (DefaultP4ServerManager.this.getLogger().isDebugEnabled()) {
                        DefaultP4ServerManager.this.getLogger().debug("Command completed in " + millisecsTaken + "ms");
                    }
                }
            });
            server.connect();
            String p4Charset = P4Utils.getSettings().getCharset();
            if (!StringUtils.isBlank((String)p4Charset) && server.isConnected() && server.supportsUnicode()) {
                server.setCharsetName(p4Charset);
            }
            if (!StringUtils.isBlank((String)repo.getUser())) {
                server.setUserName(repo.getUser());
                if (!StringUtils.isBlank((String)repo.getPassword()) && !"{}".equals(repo.getPassword())) {
                    server.login(repo.getPassword(), new LoginOptions());
                }
            }
        }
        catch (URISyntaxException e) {
            throw new ScmException(e.getLocalizedMessage(), (Throwable)e);
        }
        catch (P4JavaException e) {
            throw new ScmException(e.getLocalizedMessage(), (Throwable)e);
        }
        return server;
    }

    private static String getUrl(String p4Port) {
        String protocol = "p4java";
        String hostPort = p4Port;
        if (DefaultP4ServerManager.isSsl(p4Port)) {
            protocol = protocol + "ssl";
            hostPort = p4Port.substring(4);
        }
        return protocol + "://" + hostPort;
    }

    private static boolean isSsl(String p4Port) {
        return p4Port.startsWith("ssl:");
    }

    private void disconnectQuietly(IServer server) {
        try {
            if (server != null) {
                server.disconnect();
            }
        }
        catch (P4JavaException e) {
            this.getLogger().warn("Unable to disconnect", (Throwable)e);
        }
    }
}

