/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.maven.scm.provider.p4.repository;

import org.apache.maven.scm.provider.ScmProviderRepositoryWithHost;
import org.codehaus.plexus.util.StringUtils;

public class P4ScmProviderRepository
extends ScmProviderRepositoryWithHost {
    public static final String P4_PORT_PROPERTY = "P4PORT";
    public static final String P4_CHARSET_PROPERTY = "P4CHARSET";
    public static final String P4_CLIENT_PROPERTY = "P4CLIENT";
    public static final String P4_JOBS_PROPERTY = "P4JOBS";
    public static final String P4_VERBOSE_PROPERTY = "P4VERBOSE";
    private String protocol;
    private String path;
    private String p4Port;

    public P4ScmProviderRepository(String protocol, String host, int port, String path, String user, String password) {
        this.setProtocol(protocol);
        this.setHost(host);
        this.setPort(port);
        this.setPath(path);
        this.setUser(user);
        this.setPassword(password);
        this.p4Port = "";
        if (!StringUtils.isBlank((String)protocol)) {
            this.p4Port = this.p4Port + protocol + ":";
        }
        this.p4Port = this.p4Port + this.getHost() + ":" + this.getPort();
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        if (!path.startsWith("//")) {
            throw new IllegalArgumentException("The depot path must be start with //");
        }
        this.path = path;
    }

    public String getProtocol() {
        return this.protocol;
    }

    private void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getP4Port() {
        return this.p4Port;
    }
}

