/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.maven.scm.provider.p4.util;

import java.util.Arrays;
import java.util.HashSet;
import org.codehaus.plexus.util.StringUtils;

class P4Port {
    public static final String[] PROTOCOLS = new String[]{"tcp", "tcp4", "tcp6", "tcp46", "tcp64", "ssl", "ssl4", "ssl6", "ssl46", "ssl64"};
    private String protocol;
    private String host;
    private int port;
    private String user;
    private String password;

    public String getProtocol() {
        return this.protocol;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    private P4Port() {
    }

    public String getScm() {
        StringBuilder buff = new StringBuilder();
        if (this.protocol != null) {
            buff.append(this.protocol).append(":");
        }
        if (StringUtils.isNotBlank((String)this.user)) {
            if (StringUtils.isNotBlank((String)this.password)) {
                buff.append(this.password).append(":");
            }
            buff.append(this.user).append("@");
        }
        buff.append(this.host);
        if (this.port > 0) {
            buff.append(":").append(this.port);
        }
        return buff.toString();
    }

    public String getP4Port() {
        StringBuilder buff = new StringBuilder();
        if (this.protocol != null) {
            buff.append(this.protocol).append(":");
        }
        buff.append(this.host);
        if (this.port > 0) {
            buff.append(":").append(this.port);
        }
        return buff.toString();
    }

    public static P4Port parse(String p4Port) {
        if (StringUtils.isBlank((String)p4Port)) {
            throw new IllegalArgumentException("P4PORT cannot be blank");
        }
        String originalP4Port = p4Port;
        P4Port o = new P4Port();
        int i0 = p4Port.indexOf(":");
        if (i0 > 0) {
            o.protocol = p4Port.substring(0, i0);
            HashSet<String> protocols = new HashSet<String>(Arrays.asList(PROTOCOLS));
            if (protocols.contains(o.protocol)) {
                p4Port = p4Port.substring(i0 + 1);
            } else {
                o.protocol = null;
            }
        }
        String credentialToken = null;
        String[] tokens = StringUtils.split((String)p4Port, (String)"@");
        if (tokens.length == 2) {
            credentialToken = tokens[0];
            p4Port = tokens[1];
        } else if (tokens.length > 2) {
            throw new IllegalArgumentException("Invalid P4PORT: " + originalP4Port);
        }
        if (credentialToken != null) {
            tokens = StringUtils.split((String)credentialToken, (String)":");
            o.user = tokens[0];
            if (tokens.length == 2) {
                o.password = tokens[1];
            } else if (tokens.length > 2) {
                throw new IllegalArgumentException("Invalid P4PORT: " + originalP4Port);
            }
        } else {
            o.user = System.getenv("P4USER");
        }
        tokens = StringUtils.split((String)p4Port, (String)":");
        o.host = tokens[0];
        if (tokens.length == 2) {
            o.port = Integer.parseInt(tokens[1]);
        } else if (tokens.length > 2) {
            throw new IllegalArgumentException("Invalid P4PORT: " + originalP4Port);
        }
        return o;
    }
}

