/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.maven.scm.provider.p4.util;

import com.perforce.maven.scm.provider.p4.util.P4Port;
import com.perforce.maven.scm.provider.p4.util.P4Utils;
import java.io.File;
import java.io.IOException;
import org.codehaus.plexus.util.StringUtils;

public class P4ScmUrl {
    public static final String P4MAVEN_URL_PREFIX = "scm:p4:";
    public static final String P4PORT_KEY = "P4PORT";
    public static final String P4USER_KEY = "P4USER";
    public static final String P4MAVEN_URL_FORMAT = "scm:p4:[protocol:][[username[:password]@]hostname:port:]//depot/path/to/project";
    private static final String PARSING_ERROR = "Invalid SCM URL: The url has to be on the form: scm:p4:[protocol:][[username[:password]@]hostname:port:]//depot/path/to/project";
    private String protocol;
    private String host;
    private int port = 0;
    private String username;
    private String password;
    private String path;

    public String getProtocol() {
        return this.protocol;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getPath() {
        return this.path;
    }

    private P4ScmUrl() {
    }

    public static P4ScmUrl parse(String url) {
        P4Port p4PortEnv;
        P4ScmUrl o = P4ScmUrl.parseInternal(url);
        if (!StringUtils.isBlank((String)P4Utils.getSettings().getP4Port()) && o.host == null) {
            p4PortEnv = P4Port.parse(P4Utils.getSettings().getP4Port());
            o.host = p4PortEnv.getHost();
            o.protocol = p4PortEnv.getProtocol();
            o.port = p4PortEnv.getPort();
            o.username = p4PortEnv.getUser();
        }
        if (!StringUtils.isBlank((String)System.getenv(P4PORT_KEY)) && o.host == null) {
            p4PortEnv = P4Port.parse(System.getenv(P4PORT_KEY));
            o.host = p4PortEnv.getHost();
            o.protocol = p4PortEnv.getProtocol();
            o.port = p4PortEnv.getPort();
            o.username = p4PortEnv.getUser();
        }
        if (!StringUtils.isBlank((String)System.getProperty(P4PORT_KEY))) {
            P4Port p4PortProps = P4Port.parse(System.getProperty(P4PORT_KEY));
            o.host = p4PortProps.getHost();
            o.protocol = p4PortProps.getProtocol();
            o.port = p4PortProps.getPort();
            o.username = p4PortProps.getUser();
        }
        return o;
    }

    private static P4ScmUrl parseInternal(String url) {
        P4ScmUrl o = new P4ScmUrl();
        String[] tokens = url.split("://");
        if (tokens.length != 2) {
            throw new IllegalArgumentException(PARSING_ERROR);
        }
        o.path = "//" + P4ScmUrl.removeDotDotFromPath(tokens[1]);
        if ("scm:p4".equals(tokens[0])) {
            return o;
        }
        if (!tokens[0].startsWith(P4MAVEN_URL_PREFIX)) {
            throw new IllegalArgumentException(PARSING_ERROR);
        }
        String hostInfo = tokens[0].substring(P4MAVEN_URL_PREFIX.length());
        P4Port p4Port = P4Port.parse(hostInfo);
        o.protocol = p4Port.getProtocol();
        o.host = p4Port.getHost();
        o.port = p4Port.getPort();
        o.username = p4Port.getUser();
        o.password = p4Port.getPassword();
        return o;
    }

    public String getUrl() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(P4MAVEN_URL_PREFIX);
        if (!StringUtils.isBlank((String)this.getProtocol())) {
            buffer.append(this.getProtocol()).append(":");
        }
        if (!StringUtils.isBlank((String)this.getPassword())) {
            buffer.append(this.getPassword()).append(":").append(this.getUsername()).append("@");
        } else if (!StringUtils.isBlank((String)this.getUsername())) {
            buffer.append(this.getUsername()).append("@");
        }
        if (this.host != null) {
            buffer.append(this.host);
        }
        if (this.port > 0) {
            buffer.append(":").append(this.getPort());
        }
        buffer.append(":").append(this.getPath());
        return buffer.toString();
    }

    private static String removeDotDotFromPath(String path) {
        if (!path.contains("..")) {
            return path;
        }
        try {
            String base = new File(".").getCanonicalPath();
            String fullPath = new File(path).getCanonicalPath();
            return new File(base).toURI().relativize(new File(fullPath).toURI()).getPath();
        }
        catch (IOException e) {
            throw new IllegalArgumentException(PARSING_ERROR, e);
        }
    }
}

