/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.maven.scm.provider.p4.util;

import com.perforce.maven.scm.provider.p4.settings.Settings;
import com.perforce.maven.scm.provider.p4.settings.io.xpp3.P4MavenXpp3Reader;
import com.perforce.p4java.client.IClient;
import com.perforce.p4java.core.IChangelist;
import com.perforce.p4java.core.IChangelistSummary;
import com.perforce.p4java.core.file.FileSpecBuilder;
import com.perforce.p4java.core.file.FileSpecOpStatus;
import com.perforce.p4java.core.file.IFileSpec;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.exception.RequestException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmRevision;
import org.apache.maven.scm.ScmTag;
import org.apache.maven.scm.ScmVersion;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class P4Utils {
    private static final String P4MAVEN_SETTINGS_FILENAME = "p4maven-settings.xml";
    public static final File DEFAULT_SETTINGS_DIRECTORY;
    private static File settingsDirectory;
    private static Settings settings;

    private P4Utils() {
    }

    public static String getCanonicalRepoPath(String repoPath) {
        if (repoPath == null) {
            return null;
        }
        if (repoPath.endsWith("/")) {
            repoPath = repoPath + "...";
        } else if (!repoPath.endsWith("/...")) {
            repoPath = repoPath + "/...";
        }
        if (repoPath.contains(" ")) {
            repoPath = "\"" + repoPath + "\"";
        }
        return repoPath;
    }

    public static String encodeWildcards(String filePath) {
        String path = new String();
        if (filePath != null) {
            path = filePath.replaceAll("%", "%25").replaceAll("\\*", "%2A").replaceAll("#", "%23").replaceAll("@", "%40");
        }
        return path;
    }

    public static String getRepoLocation(IClient client, File localFile) throws P4JavaException {
        List fileSpecs = client.where(FileSpecBuilder.makeFileSpecList((String)P4Utils.encodeWildcards(localFile.getAbsolutePath())));
        for (IFileSpec fileSpec : fileSpecs) {
            if (StringUtils.isBlank((String)fileSpec.getDepotPathString())) continue;
            return fileSpec.getDepotPathString();
        }
        return null;
    }

    public static boolean isRepoPathValid(IClient client, String repoPath) throws P4JavaException {
        IFileSpec fileSpec;
        List fileSpecs = client.where(FileSpecBuilder.makeFileSpecList((String)P4Utils.getCanonicalRepoPath(repoPath)));
        return fileSpecs.size() != 0 && (fileSpec = (IFileSpec)fileSpecs.get(0)).getOpStatus() == FileSpecOpStatus.VALID;
    }

    public static String scmVersion2SuffixString(ScmVersion version) {
        String versionSuffix = "";
        if (version != null && !StringUtils.isBlank((String)version.getName())) {
            versionSuffix = "@" + version.getName();
        }
        return versionSuffix;
    }

    public static IChangelistSummary getLatestChangelist(IClient client, File basedir, ScmVersion scmVersion, boolean useHead) throws ScmException {
        String filePath = basedir.getAbsolutePath();
        filePath = scmVersion instanceof ScmTag || scmVersion instanceof ScmRevision ? "@" + scmVersion.getName() : (useHead ? filePath + "/...#head" : filePath + "/...#have");
        List fileSpecs = FileSpecBuilder.makeFileSpecList((String[])new String[]{filePath});
        try {
            List results = client.getServer().getChangelists(1, fileSpecs, null, null, false, IChangelist.Type.SUBMITTED, false);
            if (results.isEmpty()) {
                if (scmVersion != null && !useHead) {
                    return null;
                }
                throw new RequestException("Changelist not available");
            }
            return (IChangelistSummary)results.get(0);
        }
        catch (Exception e) {
            throw new ScmException("Unable to retrieve current change list number", (Throwable)e);
        }
    }

    public static List<IFileSpec> scmFileSet2P4FileSpecsWithNoP4WildCard(ScmFileSet fileSet, ScmVersion version) throws ScmException {
        List<Object> fileSpecs = new ArrayList<IFileSpec>();
        try {
            List fileList = fileSet.getFileList();
            if (fileList != null) {
                String versionSuffix = P4Utils.scmVersion2SuffixString(version);
                HashSet<String> filePaths = new HashSet<String>();
                for (File file : fileList) {
                    if (".".equals(file.getPath())) continue;
                    if (!file.isAbsolute()) {
                        file = new File(fileSet.getBasedir(), file.getPath());
                    }
                    filePaths.add(P4Utils.encodeWildcards(file.getCanonicalPath() + versionSuffix));
                }
                if (!filePaths.isEmpty()) {
                    fileSpecs = FileSpecBuilder.makeFileSpecList((String[])filePaths.toArray(new String[filePaths.size()]));
                }
            }
        }
        catch (IOException e) {
            throw new ScmException(e.getLocalizedMessage(), (Throwable)e);
        }
        return fileSpecs;
    }

    public static List<IFileSpec> scmFileSet2P4FileSpecsWithNoP4WildCard(ScmFileSet fileSet) throws ScmException {
        return P4Utils.scmFileSet2P4FileSpecsWithNoP4WildCard(fileSet, null);
    }

    public static List<IFileSpec> scmFileSet2P4FileSpecs(ScmFileSet fileSet, ScmVersion version) throws ScmException {
        List fileSpecs = P4Utils.scmFileSet2P4FileSpecsWithNoP4WildCard(fileSet, version);
        if (fileSpecs.isEmpty() && StringUtils.isBlank((String)fileSet.getIncludes()) && StringUtils.isBlank((String)fileSet.getExcludes())) {
            String versionSuffix = P4Utils.scmVersion2SuffixString(version);
            if (StringUtils.isBlank((String)versionSuffix)) {
                versionSuffix = "/...";
            }
            String filePath = fileSet.getBasedir().getAbsolutePath() + versionSuffix;
            if (version instanceof ScmTag || version instanceof ScmRevision) {
                filePath = "@" + version.getName();
            }
            fileSpecs = FileSpecBuilder.makeFileSpecList((String[])new String[]{filePath});
        }
        return fileSpecs;
    }

    public static List<IFileSpec> scmFileSet2P4FileSpecs(ScmFileSet fileSet) throws ScmException {
        return P4Utils.scmFileSet2P4FileSpecs(fileSet, null);
    }

    public static synchronized void resetSettings() {
        settings = null;
    }

    public static void setP4MavenSettingsDirecotry(File location) {
        settingsDirectory = location;
    }

    public static synchronized Settings getSettings() {
        if (settings == null) {
            settings = P4Utils.readSettings();
        }
        return settings;
    }

    private static Settings readSettings() {
        String strictClientDiscovery;
        String verbose;
        String charset;
        String jobs;
        File settingsFile = P4Utils.getSettingsFile();
        Settings settings = new Settings();
        if (settingsFile.exists()) {
            P4MavenXpp3Reader reader = new P4MavenXpp3Reader();
            try {
                settings = reader.read((Reader)ReaderFactory.newXmlReader((File)settingsFile));
            }
            catch (FileNotFoundException e) {
            }
            catch (IOException e) {
            }
            catch (XmlPullParserException e) {
                String message = settingsFile.getAbsolutePath() + " isn't well formed. SKIPPED." + e.getMessage();
                System.err.println(message);
            }
        }
        if ((jobs = System.getProperty("P4JOBS")) == null) {
            jobs = System.getProperty("P4JOBS".toLowerCase());
        }
        if (jobs != null) {
            settings.setJobs(jobs);
        }
        settings.setClientName(null);
        String clientName = System.getProperty("P4CLIENT");
        if (clientName == null) {
            clientName = System.getProperty("P4CLIENT".toLowerCase());
        }
        if (clientName != null) {
            settings.setClientName(clientName);
        }
        if ((charset = System.getProperty("P4CHARSET")) != null) {
            settings.setCharset(charset);
        }
        if ((verbose = System.getProperty("P4VERBOSE")) == null) {
            verbose = System.getProperty("P4VERBOSE".toLowerCase());
        }
        if (verbose != null) {
            settings.setVerbose(false);
            if ("true".equals(verbose)) {
                settings.setVerbose(true);
            }
        }
        if ("true".equals(strictClientDiscovery = System.getProperty("strictClientDiscovery"))) {
            settings.setStrictClientDiscovery(true);
        }
        return settings;
    }

    public static List<String> getJobs() {
        String jobs = P4Utils.getSettings().getJobs();
        if (jobs == null) {
            jobs = "";
        }
        String[] tokens = StringUtils.split((String)jobs);
        return new ArrayList<String>(Arrays.asList(tokens));
    }

    private static File getSettingsFile() {
        return new File(settingsDirectory, P4MAVEN_SETTINGS_FILENAME);
    }

    public static void setSettingsDirectory(File directory) {
        settingsDirectory = directory;
    }

    static {
        settingsDirectory = DEFAULT_SETTINGS_DIRECTORY = new File(System.getProperty("user.home"), ".m2");
    }
}

