/*
 * Decompiled with CFR 0.152.
 */
package com.personio.synthetics.builder;

import com.datadog.api.client.v1.model.SyntheticsDeviceID;
import com.datadog.api.client.v1.model.SyntheticsGlobalVariable;
import com.datadog.api.client.v1.model.SyntheticsTestOptions;
import com.datadog.api.client.v1.model.SyntheticsTestOptionsMonitorOptions;
import com.datadog.api.client.v1.model.SyntheticsTestOptionsRetry;
import com.datadog.api.client.v1.model.SyntheticsTestOptionsScheduling;
import com.datadog.api.client.v1.model.SyntheticsTestOptionsSchedulingTimeframe;
import com.personio.synthetics.client.SyntheticsApiClient;
import com.personio.synthetics.config.Defaults;
import com.personio.synthetics.domain.SyntheticTestParameters;
import com.personio.synthetics.model.config.Location;
import com.personio.synthetics.model.config.MonitorPriority;
import com.personio.synthetics.model.config.RenotifyInterval;
import com.personio.synthetics.model.config.Timeframe;
import java.time.DayOfWeek;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u0003H$J\u0018\u0010 \u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\"2\b\b\u0002\u0010#\u001a\u00020$J'\u0010%\u001a\u00020\u001e2\u0006\u0010&\u001a\u00020\u00032\u0012\u0010'\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030(\"\u00020\u0003\u00a2\u0006\u0002\u0010)J*\u0010*\u001a\u00020\u001e2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010+\u001a\u00020,2\b\b\u0002\u0010-\u001a\u00020\u00032\b\b\u0002\u0010.\u001a\u00020\u0003J*\u0010/\u001a\u00020\u001e2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010+\u001a\u00020,2\b\b\u0002\u0010-\u001a\u00020\u00032\b\b\u0002\u0010.\u001a\u00020\u0003J?\u00100\u001a\u00020\u001e2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u00020\u00032\b\b\u0002\u0010-\u001a\u00020\u00032\b\b\u0002\u0010.\u001a\u00020\u0003\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b4\u00105J\u0012\u00106\u001a\u0004\u0018\u00010\u00032\u0006\u00107\u001a\u00020\u0003H\u0004J+\u00108\u001a\u0010\u0012\u0004\u0012\u00020:\u0012\u0004\u0012\u00020\u0003\u0018\u0001092\u0006\u0010;\u001a\u000202H\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b<\u0010=J+\u0010>\u001a\u0010\u0012\u0004\u0012\u00020:\u0012\u0004\u0012\u00020\u0003\u0018\u0001092\u0006\u0010;\u001a\u000202H\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b?\u0010=J\u001b\u0010@\u001a\u00020\u001e2\u0006\u0010@\u001a\u000202\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\bA\u0010BJ\u000e\u0010C\u001a\u00020\u001e2\u0006\u0010C\u001a\u00020:J\u000e\u0010D\u001a\u00020\u001e2\u0006\u0010D\u001a\u00020\u0003J\u000e\u0010E\u001a\u00020\u001e2\u0006\u0010F\u001a\u00020GJ*\u0010H\u001a\u00020\u001e2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010+\u001a\u00020,2\b\b\u0002\u0010-\u001a\u00020\u00032\b\b\u0002\u0010.\u001a\u00020\u0003J\u001f\u0010I\u001a\u00020\u001e2\u0012\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020J0(\"\u00020J\u00a2\u0006\u0002\u0010KJ\u000e\u0010L\u001a\u00020\u001e2\u0006\u0010L\u001a\u00020\u0003J\u000e\u0010M\u001a\u00020\u001e2\u0006\u0010M\u001a\u00020NJ#\u0010O\u001a\u00020\u001e2\u0006\u0010P\u001a\u00020:2\u0006\u0010Q\u001a\u000202\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\bR\u0010SJ\u001f\u0010T\u001a\u00020\u001e2\u0012\u0010T\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030(\"\u00020\u0003\u00a2\u0006\u0002\u0010UJ\u001b\u0010V\u001a\u00020\u001e2\u0006\u0010W\u001a\u000202\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\bX\u0010BJ\u0016\u0010Y\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010;\u001a\u00020\u0003J7\u0010Z\u001a\u00020\u001e2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u00101\u001a\u0002022\b\b\u0002\u0010-\u001a\u00020\u00032\b\b\u0002\u0010.\u001a\u00020\u0003\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b[\u0010\\J\u0010\u0010]\u001a\u00020\u001e2\u0006\u0010\u0002\u001a\u00020\u0003H&J\u000e\u0010^\u001a\u00020\u001e2\u0006\u0010\u0002\u001a\u00020\u0003J=\u0010_\u001a\u0010\u0012\u0004\u0012\u00020:\u0012\u0004\u0012\u00020\u0003\u0018\u000109*\u0002022\f\u0010`\u001a\b\u0012\u0004\u0012\u00020b0a2\u0006\u0010c\u001a\u00020:H\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\bd\u0010eJ\f\u0010f\u001a\u00020\u0003*\u00020bH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00030\nX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0012X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\u0018X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001c\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b\u0019\u00a8\u0006g"}, d2={"Lcom/personio/synthetics/builder/SyntheticTestBuilder;", "", "name", "", "defaults", "Lcom/personio/synthetics/config/Defaults;", "apiClient", "Lcom/personio/synthetics/client/SyntheticsApiClient;", "(Ljava/lang/String;Lcom/personio/synthetics/config/Defaults;Lcom/personio/synthetics/client/SyntheticsApiClient;)V", "locations", "", "getLocations", "()Ljava/util/List;", "setLocations", "(Ljava/util/List;)V", "getName", "()Ljava/lang/String;", "options", "Lcom/datadog/api/client/v1/model/SyntheticsTestOptions;", "getOptions", "()Lcom/datadog/api/client/v1/model/SyntheticsTestOptions;", "setOptions", "(Lcom/datadog/api/client/v1/model/SyntheticsTestOptions;)V", "parameters", "Lcom/personio/synthetics/domain/SyntheticTestParameters;", "getParameters", "()Lcom/personio/synthetics/domain/SyntheticTestParameters;", "setParameters", "(Lcom/personio/synthetics/domain/SyntheticTestParameters;)V", "addLocalVariable", "", "pattern", "advancedScheduling", "timeframe", "Lcom/personio/synthetics/model/config/Timeframe;", "timezone", "Ljava/time/ZoneId;", "alertMessage", "failureMessage", "alertMedium", "", "(Ljava/lang/String;[Ljava/lang/String;)V", "alphabeticPatternVariable", "characterLength", "", "prefix", "suffix", "alphanumericPatternVariable", "datePatternVariable", "duration", "Lkotlin/time/Duration;", "format", "datePatternVariable-WPwdCS8", "(Ljava/lang/String;JLjava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getGlobalVariableId", "variableName", "getScaledDate", "Lkotlin/Pair;", "", "value", "getScaledDate-LRDsOJo", "(J)Lkotlin/Pair;", "getScaledTimestamp", "getScaledTimestamp-LRDsOJo", "minFailureDuration", "minFailureDuration-LRDsOJo", "(J)V", "minLocationFailed", "monitorName", "monitorPriority", "monitorPriorities", "Lcom/personio/synthetics/model/config/MonitorPriority;", "numericPatternVariable", "publicLocations", "Lcom/personio/synthetics/model/config/Location;", "([Lcom/personio/synthetics/model/config/Location;)V", "recoveryMessage", "renotifyInterval", "Lcom/personio/synthetics/model/config/RenotifyInterval;", "retry", "retryCount", "retryInterval", "retry-HG0u8IE", "(JJ)V", "tags", "([Ljava/lang/String;)V", "testFrequency", "frequency", "testFrequency-LRDsOJo", "textVariable", "timestampPatternVariable", "timestampPatternVariable-dWUq8MI", "(Ljava/lang/String;JLjava/lang/String;Ljava/lang/String;)V", "useGlobalVariable", "uuidVariable", "getScaledValue", "sequence", "Lkotlin/sequences/Sequence;", "Lkotlin/time/DurationUnit;", "limit", "getScaledValue-KLykuaI", "(JLkotlin/sequences/Sequence;J)Lkotlin/Pair;", "toDatadogDurationUnit", "datadog-synthetic-test-support"})
@SourceDebugExtension(value={"SMAP\nSyntheticTestBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SyntheticTestBuilder.kt\ncom/personio/synthetics/builder/SyntheticTestBuilder\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,321:1\n11065#2:322\n11400#2,3:323\n11065#2:326\n11400#2,3:327\n179#3,2:330\n1#4:332\n*S KotlinDebug\n*F\n+ 1 SyntheticTestBuilder.kt\ncom/personio/synthetics/builder/SyntheticTestBuilder\n*L\n102#1:322\n102#1:323,3\n128#1:326\n128#1:327,3\n297#1:330,2\n*E\n"})
public abstract class SyntheticTestBuilder {
    @NotNull
    private final String name;
    @NotNull
    private final SyntheticsApiClient apiClient;
    @NotNull
    private SyntheticTestParameters parameters;
    @NotNull
    private SyntheticsTestOptions options;
    @NotNull
    private List<String> locations;

    public SyntheticTestBuilder(@NotNull String name, @NotNull Defaults defaults, @NotNull SyntheticsApiClient apiClient) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)defaults, (String)"defaults");
        Intrinsics.checkNotNullParameter((Object)((Object)apiClient), (String)"apiClient");
        this.name = name;
        this.apiClient = apiClient;
        this.locations = defaults.getRunLocations();
        this.parameters = new SyntheticTestParameters("", defaults.getRunLocations(), new ArrayList());
        SyntheticsTestOptions syntheticsTestOptions = new SyntheticsTestOptions().addDeviceIdsItem(SyntheticsDeviceID.CHROME_LAPTOP_LARGE).tickEvery(Long.valueOf(defaults.getTestFrequency() / (long)1000)).minFailureDuration(Long.valueOf(defaults.getMinFailureDuration() / (long)1000)).minLocationFailed(Long.valueOf(defaults.getMinLocationFailed())).retry(new SyntheticsTestOptionsRetry().count(Long.valueOf(defaults.getRetryCount())).interval(Double.valueOf(defaults.getRetryInterval()))).monitorOptions(new SyntheticsTestOptionsMonitorOptions());
        Intrinsics.checkNotNullExpressionValue((Object)syntheticsTestOptions, (String)"monitorOptions(...)");
        this.options = syntheticsTestOptions;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    protected final SyntheticTestParameters getParameters() {
        return this.parameters;
    }

    protected final void setParameters(@NotNull SyntheticTestParameters syntheticTestParameters) {
        Intrinsics.checkNotNullParameter((Object)syntheticTestParameters, (String)"<set-?>");
        this.parameters = syntheticTestParameters;
    }

    @NotNull
    protected final SyntheticsTestOptions getOptions() {
        return this.options;
    }

    protected final void setOptions(@NotNull SyntheticsTestOptions syntheticsTestOptions) {
        Intrinsics.checkNotNullParameter((Object)syntheticsTestOptions, (String)"<set-?>");
        this.options = syntheticsTestOptions;
    }

    @NotNull
    protected final List<String> getLocations() {
        return this.locations;
    }

    protected final void setLocations(@NotNull List<String> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.locations = list;
    }

    public final void monitorName(@NotNull String monitorName) {
        Intrinsics.checkNotNullParameter((Object)monitorName, (String)"monitorName");
        this.options.setMonitorName(monitorName);
    }

    public final void alertMessage(@NotNull String failureMessage, String ... alertMedium) {
        Intrinsics.checkNotNullParameter((Object)failureMessage, (String)"failureMessage");
        Intrinsics.checkNotNullParameter((Object)alertMedium, (String)"alertMedium");
        SyntheticTestParameters syntheticTestParameters = this.parameters;
        syntheticTestParameters.setMessage(syntheticTestParameters.getMessage() + ArraysKt.joinToString$default((Object[])alertMedium, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null) + " {{#is_alert}} " + failureMessage + " {{/is_alert}} ");
    }

    public final void recoveryMessage(@NotNull String recoveryMessage) {
        Intrinsics.checkNotNullParameter((Object)recoveryMessage, (String)"recoveryMessage");
        SyntheticTestParameters syntheticTestParameters = this.parameters;
        syntheticTestParameters.setMessage(syntheticTestParameters.getMessage() + " {{#is_recovery}} " + recoveryMessage + " {{/is_recovery}} ");
    }

    public final void tags(String ... tags) {
        Intrinsics.checkNotNullParameter((Object)tags, (String)"tags");
        CollectionsKt.addAll((Collection)this.parameters.getTags(), (Object[])tags);
    }

    /*
     * WARNING - void declaration
     */
    public final void publicLocations(Location ... locations) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)locations, (String)"locations");
        Location[] locationArray = locations;
        SyntheticTestParameters syntheticTestParameters = this.parameters;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var10_11 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getValue());
        }
        syntheticTestParameters.setLocations((List)destination$iv$iv);
    }

    public final void testFrequency-LRDsOJo(long frequency) {
        long l = DurationKt.toDuration((int)30, (DurationUnit)DurationUnit.SECONDS);
        if (!(Duration.box-impl((long)frequency).compareTo((Object)Duration.box-impl((long)DurationKt.toDuration((int)7, (DurationUnit)DurationUnit.DAYS))) <= 0 ? 0 <= Duration.box-impl((long)frequency).compareTo((Object)Duration.box-impl((long)l)) : false)) {
            boolean bl = false;
            String string = "Frequency should be between 30 seconds and 1 week.";
            throw new IllegalArgumentException(string.toString());
        }
        this.options.setTickEvery(Long.valueOf(Duration.getInWholeSeconds-impl((long)frequency)));
    }

    /*
     * WARNING - void declaration
     */
    public final void advancedScheduling(@NotNull Timeframe timeframe, @NotNull ZoneId timezone) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)timeframe, (String)"timeframe");
        Intrinsics.checkNotNullParameter((Object)timezone, (String)"timezone");
        this.options.setScheduling(new SyntheticsTestOptionsScheduling());
        DayOfWeek[] dayOfWeekArray = timeframe.getDays();
        SyntheticsTestOptionsScheduling syntheticsTestOptionsScheduling = this.options.getScheduling();
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            SyntheticsTestOptionsSchedulingTimeframe syntheticsTestOptionsSchedulingTimeframe;
            void item$iv$iv;
            void var11_12 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            SyntheticsTestOptionsSchedulingTimeframe $this$advancedScheduling_u24lambda_u243_u24lambda_u242 = syntheticsTestOptionsSchedulingTimeframe = new SyntheticsTestOptionsSchedulingTimeframe();
            boolean bl2 = false;
            $this$advancedScheduling_u24lambda_u243_u24lambda_u242.setFrom(timeframe.getFrom().truncatedTo(ChronoUnit.MINUTES).toString());
            $this$advancedScheduling_u24lambda_u243_u24lambda_u242.setTo(timeframe.getTo().truncatedTo(ChronoUnit.MINUTES).toString());
            $this$advancedScheduling_u24lambda_u243_u24lambda_u242.setDay(Integer.valueOf(it.getValue()));
            collection.add(syntheticsTestOptionsSchedulingTimeframe);
        }
        syntheticsTestOptionsScheduling.setTimeframes((List)destination$iv$iv);
        this.options.getScheduling().setTimezone(timezone.toString());
    }

    public static /* synthetic */ void advancedScheduling$default(SyntheticTestBuilder syntheticTestBuilder, Timeframe timeframe, ZoneId zoneId, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: advancedScheduling");
        }
        if ((n & 2) != 0) {
            ZoneId zoneId2 = ZoneId.systemDefault();
            Intrinsics.checkNotNullExpressionValue((Object)zoneId2, (String)"systemDefault(...)");
            zoneId = zoneId2;
        }
        syntheticTestBuilder.advancedScheduling(timeframe, zoneId);
    }

    public final void retry-HG0u8IE(long retryCount, long retryInterval) {
        if (!(0L <= retryCount ? retryCount < 3L : false)) {
            boolean $i$a$-require-SyntheticTestBuilder$retry$32 = false;
            String $i$a$-require-SyntheticTestBuilder$retry$32 = "Retry count should be between 0 and 2.";
            throw new IllegalArgumentException($i$a$-require-SyntheticTestBuilder$retry$32.toString());
        }
        long l = DurationKt.toDuration((int)0, (DurationUnit)DurationUnit.MILLISECONDS);
        if (!(Duration.box-impl((long)retryInterval).compareTo((Object)Duration.box-impl((long)DurationKt.toDuration((int)15, (DurationUnit)DurationUnit.MINUTES))) <= 0 ? 0 <= Duration.box-impl((long)retryInterval).compareTo((Object)Duration.box-impl((long)l)) : false)) {
            boolean bl = false;
            String string = "Retry interval should be between 0 and 15 minutes.";
            throw new IllegalArgumentException(string.toString());
        }
        this.options.getRetry().setCount(Long.valueOf(retryCount));
        this.options.getRetry().setInterval(Double.valueOf(Duration.getInWholeMilliseconds-impl((long)retryInterval)));
    }

    public final void minFailureDuration-LRDsOJo(long minFailureDuration) {
        long l = DurationKt.toDuration((int)0, (DurationUnit)DurationUnit.MINUTES);
        if (!(Duration.box-impl((long)minFailureDuration).compareTo((Object)Duration.box-impl((long)DurationKt.toDuration((int)120, (DurationUnit)DurationUnit.MINUTES))) <= 0 ? 0 <= Duration.box-impl((long)minFailureDuration).compareTo((Object)Duration.box-impl((long)l)) : false)) {
            boolean bl = false;
            String string = "Minimum failure duration should be between 0 and 120 minutes.";
            throw new IllegalArgumentException(string.toString());
        }
        this.options.setMinFailureDuration(Long.valueOf(Duration.getInWholeSeconds-impl((long)minFailureDuration)));
    }

    public final void minLocationFailed(long minLocationFailed) {
        if (!(1L <= minLocationFailed ? minLocationFailed <= (long)((Collection)this.locations).size() : false)) {
            boolean bl = false;
            String string = "Minimum location failed should be between 1 and the number of locations where the test is configured to run: " + ((Collection)this.locations).size() + ".";
            throw new IllegalArgumentException(string.toString());
        }
        this.options.setMinLocationFailed(Long.valueOf(minLocationFailed));
    }

    public final void renotifyInterval(@NotNull RenotifyInterval renotifyInterval) {
        Intrinsics.checkNotNullParameter((Object)((Object)renotifyInterval), (String)"renotifyInterval");
        SyntheticsTestOptionsMonitorOptions syntheticsTestOptionsMonitorOptions = this.options.getMonitorOptions();
        Intrinsics.checkNotNull((Object)syntheticsTestOptionsMonitorOptions);
        syntheticsTestOptionsMonitorOptions.setRenotifyInterval(Long.valueOf(renotifyInterval.getValueInMinutes()));
    }

    public final void monitorPriority(@NotNull MonitorPriority monitorPriorities) {
        Intrinsics.checkNotNullParameter((Object)((Object)monitorPriorities), (String)"monitorPriorities");
        this.options.setMonitorPriority(Integer.valueOf(monitorPriorities.getPriorityValue()));
    }

    @NotNull
    public final SyntheticTestBuilder textVariable(@NotNull String name, @NotNull String value) {
        SyntheticTestBuilder syntheticTestBuilder;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        SyntheticTestBuilder $this$textVariable_u24lambda_u248 = syntheticTestBuilder = this;
        boolean bl = false;
        $this$textVariable_u24lambda_u248.addLocalVariable(name, value);
        return syntheticTestBuilder;
    }

    public final void numericPatternVariable(@NotNull String name, int characterLength, @NotNull String prefix, @NotNull String suffix) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        Intrinsics.checkNotNullParameter((Object)suffix, (String)"suffix");
        this.addLocalVariable(name, prefix + "{{ numeric(" + characterLength + ") }}" + suffix);
    }

    public static /* synthetic */ void numericPatternVariable$default(SyntheticTestBuilder syntheticTestBuilder, String string, int n, String string2, String string3, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: numericPatternVariable");
        }
        if ((n2 & 4) != 0) {
            string2 = "";
        }
        if ((n2 & 8) != 0) {
            string3 = "";
        }
        syntheticTestBuilder.numericPatternVariable(string, n, string2, string3);
    }

    public final void alphabeticPatternVariable(@NotNull String name, int characterLength, @NotNull String prefix, @NotNull String suffix) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        Intrinsics.checkNotNullParameter((Object)suffix, (String)"suffix");
        this.addLocalVariable(name, prefix + "{{ alphabetic(" + characterLength + ") }}" + suffix);
    }

    public static /* synthetic */ void alphabeticPatternVariable$default(SyntheticTestBuilder syntheticTestBuilder, String string, int n, String string2, String string3, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: alphabeticPatternVariable");
        }
        if ((n2 & 4) != 0) {
            string2 = "";
        }
        if ((n2 & 8) != 0) {
            string3 = "";
        }
        syntheticTestBuilder.alphabeticPatternVariable(string, n, string2, string3);
    }

    public final void alphanumericPatternVariable(@NotNull String name, int characterLength, @NotNull String prefix, @NotNull String suffix) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        Intrinsics.checkNotNullParameter((Object)suffix, (String)"suffix");
        this.addLocalVariable(name, prefix + "{{ alphanumeric(" + characterLength + ") }}" + suffix);
    }

    public static /* synthetic */ void alphanumericPatternVariable$default(SyntheticTestBuilder syntheticTestBuilder, String string, int n, String string2, String string3, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: alphanumericPatternVariable");
        }
        if ((n2 & 4) != 0) {
            string2 = "";
        }
        if ((n2 & 8) != 0) {
            string3 = "";
        }
        syntheticTestBuilder.alphanumericPatternVariable(string, n, string2, string3);
    }

    public final void datePatternVariable-WPwdCS8(@NotNull String name, long duration, @NotNull String format, @NotNull String prefix, @NotNull String suffix) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        Intrinsics.checkNotNullParameter((Object)suffix, (String)"suffix");
        Pair<Long, String> pair = this.getScaledDate-LRDsOJo(duration);
        if (pair == null) {
            boolean bl = false;
            String string = "The passed duration should be less than 10_000_000 days for the date pattern variable " + name + ".";
            throw new IllegalStateException(string.toString());
        }
        Pair<Long, String> pair2 = pair;
        long scaledValue = ((Number)pair2.component1()).longValue();
        String unit = (String)pair2.component2();
        this.addLocalVariable(name, prefix + "{{ date(" + scaledValue + unit + ", " + format + ") }}" + suffix);
    }

    public static /* synthetic */ void datePatternVariable-WPwdCS8$default(SyntheticTestBuilder syntheticTestBuilder, String string, long l, String string2, String string3, String string4, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: datePatternVariable-WPwdCS8");
        }
        if ((n & 8) != 0) {
            string3 = "";
        }
        if ((n & 0x10) != 0) {
            string4 = "";
        }
        syntheticTestBuilder.datePatternVariable-WPwdCS8(string, l, string2, string3, string4);
    }

    public final void timestampPatternVariable-dWUq8MI(@NotNull String name, long duration, @NotNull String prefix, @NotNull String suffix) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        Intrinsics.checkNotNullParameter((Object)suffix, (String)"suffix");
        Pair<Long, String> pair = this.getScaledTimestamp-LRDsOJo(duration);
        if (pair == null) {
            boolean bl = false;
            String string = "The passed duration should be less than 1_000_000_000 seconds for the timestamp pattern variable " + name + ".";
            throw new IllegalStateException(string.toString());
        }
        Pair<Long, String> pair2 = pair;
        long scaledValue = ((Number)pair2.component1()).longValue();
        String unit = (String)pair2.component2();
        this.addLocalVariable(name, prefix + "{{ timestamp(" + scaledValue + ", " + unit + ") }}" + suffix);
    }

    public static /* synthetic */ void timestampPatternVariable-dWUq8MI$default(SyntheticTestBuilder syntheticTestBuilder, String string, long l, String string2, String string3, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: timestampPatternVariable-dWUq8MI");
        }
        if ((n & 4) != 0) {
            string2 = "";
        }
        if ((n & 8) != 0) {
            string3 = "";
        }
        syntheticTestBuilder.timestampPatternVariable-dWUq8MI(string, l, string2, string3);
    }

    public final void uuidVariable(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.addLocalVariable(name, "{{ uuid }}");
    }

    private final Pair<Long, String> getScaledDate-LRDsOJo(long value) {
        Object[] objectArray = new DurationUnit[]{DurationUnit.MILLISECONDS, DurationUnit.SECONDS, DurationUnit.MINUTES, DurationUnit.HOURS, DurationUnit.DAYS};
        return this.getScaledValue-KLykuaI(value, (Sequence<? extends DurationUnit>)SequencesKt.sequenceOf((Object[])objectArray), 10000000L);
    }

    private final Pair<Long, String> getScaledTimestamp-LRDsOJo(long value) {
        Object[] objectArray = new DurationUnit[]{DurationUnit.MILLISECONDS, DurationUnit.SECONDS};
        return this.getScaledValue-KLykuaI(value, (Sequence<? extends DurationUnit>)SequencesKt.sequenceOf((Object[])objectArray), 1000000000L);
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<Long, String> getScaledValue-KLykuaI(long $this$getScaledValue_u2dKLykuaI, Sequence<? extends DurationUnit> sequence, long limit) {
        Object v0;
        block1: {
            void $this$firstOrNull$iv;
            Sequence sequence2 = SequencesKt.map(sequence, (Function1)((Function1)new Function1<DurationUnit, Pair<? extends Long, ? extends String>>($this$getScaledValue_u2dKLykuaI, this){
                final /* synthetic */ long $this_getScaledValue;
                final /* synthetic */ SyntheticTestBuilder this$0;
                {
                    this.$this_getScaledValue = $receiver;
                    this.this$0 = $receiver2;
                    super(1);
                }

                @NotNull
                public final Pair<Long, String> invoke(@NotNull DurationUnit unit) {
                    Intrinsics.checkNotNullParameter((Object)unit, (String)"unit");
                    return TuplesKt.to((Object)Duration.toLong-impl((long)this.$this_getScaledValue, (DurationUnit)unit), (Object)SyntheticTestBuilder.access$toDatadogDurationUnit(this.this$0, unit));
                }
            }));
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Pair pair = (Pair)element$iv;
                boolean bl = false;
                long scaled = ((Number)pair.component1()).longValue();
                if (!(Math.abs(scaled) < limit)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    private final String toDatadogDurationUnit(DurationUnit $this$toDatadogDurationUnit) {
        return switch (WhenMappings.$EnumSwitchMapping$0[$this$toDatadogDurationUnit.ordinal()]) {
            case 1 -> "ms";
            case 2 -> "s";
            case 3 -> "m";
            case 4 -> "h";
            case 5 -> "d";
            default -> throw new IllegalArgumentException("The given duration unit is not supported.");
        };
    }

    @Nullable
    protected final String getGlobalVariableId(@NotNull String variableName) {
        Object v1;
        block2: {
            Intrinsics.checkNotNullParameter((Object)variableName, (String)"variableName");
            List list = this.apiClient.listGlobalVariables().getVariables();
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            Iterable iterable = CollectionsKt.filterNotNull((Iterable)list);
            for (Object t : iterable) {
                SyntheticsGlobalVariable it = (SyntheticsGlobalVariable)t;
                boolean bl = false;
                if (!it.getName().equals(variableName)) continue;
                v1 = t;
                break block2;
            }
            v1 = null;
        }
        SyntheticsGlobalVariable syntheticsGlobalVariable = v1;
        return syntheticsGlobalVariable != null ? syntheticsGlobalVariable.getId() : null;
    }

    protected abstract void addLocalVariable(@NotNull String var1, @NotNull String var2);

    public abstract void useGlobalVariable(@NotNull String var1);

    public static final /* synthetic */ String access$toDatadogDurationUnit(SyntheticTestBuilder $this, DurationUnit $receiver) {
        return $this.toDatadogDurationUnit($receiver);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DurationUnit.values().length];
            try {
                nArray[DurationUnit.MILLISECONDS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DurationUnit.SECONDS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DurationUnit.MINUTES.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DurationUnit.HOURS.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DurationUnit.DAYS.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

