/*
 * Decompiled with CFR 0.152.
 */
package com.personio.synthetics.builder;

import com.datadog.api.client.v1.model.SyntheticsBrowserTest;
import com.datadog.api.client.v1.model.SyntheticsBrowserTestConfig;
import com.datadog.api.client.v1.model.SyntheticsBrowserTestType;
import com.datadog.api.client.v1.model.SyntheticsBrowserVariable;
import com.datadog.api.client.v1.model.SyntheticsBrowserVariableType;
import com.datadog.api.client.v1.model.SyntheticsDeviceID;
import com.datadog.api.client.v1.model.SyntheticsTestOptions;
import com.datadog.api.client.v1.model.SyntheticsTestPauseStatus;
import com.datadog.api.client.v1.model.SyntheticsTestRequest;
import com.personio.synthetics.builder.SyntheticTestBuilder;
import com.personio.synthetics.client.SyntheticsApiClient;
import com.personio.synthetics.config.Defaults;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0003H\u0014J\u000e\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012J!\u0010\u0013\u001a\u00020\u000e2\u0012\u0010\u0014\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00160\u0015\"\u00020\u0016H\u0007\u00a2\u0006\u0002\u0010\u0017J\u001f\u0010\u0018\u001a\u00020\u000e2\u0012\u0010\u0014\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00160\u0015\"\u00020\u0016\u00a2\u0006\u0002\u0010\u0017J\u0006\u0010\u0019\u001a\u00020\u001aJ\u001d\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0010\u0010 \u001a\u00020\u000e2\u0006\u0010\u0002\u001a\u00020\u0003H\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b\u0019\u00a8\u0006!"}, d2={"Lcom/personio/synthetics/builder/SyntheticBrowserTestBuilder;", "Lcom/personio/synthetics/builder/SyntheticTestBuilder;", "name", "", "defaults", "Lcom/personio/synthetics/config/Defaults;", "apiClient", "Lcom/personio/synthetics/client/SyntheticsApiClient;", "(Ljava/lang/String;Lcom/personio/synthetics/config/Defaults;Lcom/personio/synthetics/client/SyntheticsApiClient;)V", "config", "Lcom/datadog/api/client/v1/model/SyntheticsBrowserTestConfig;", "getName", "()Ljava/lang/String;", "addLocalVariable", "", "pattern", "baseUrl", "url", "Ljava/net/URL;", "browserAndDevice", "deviceIds", "", "Lcom/datadog/api/client/v1/model/SyntheticsDeviceID;", "([Lcom/datadog/api/client/v1/model/SyntheticsDeviceID;)V", "browsersAndDevices", "build", "Lcom/datadog/api/client/v1/model/SyntheticsBrowserTest;", "testFrequency", "frequency", "Lkotlin/time/Duration;", "testFrequency-LRDsOJo", "(J)V", "useGlobalVariable", "datadog-synthetic-test-support"})
@SourceDebugExtension(value={"SMAP\nSyntheticBrowserTestBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SyntheticBrowserTestBuilder.kt\ncom/personio/synthetics/builder/SyntheticBrowserTestBuilder\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,112:1\n11065#2:113\n11400#2,3:114\n11065#2:117\n11400#2,3:118\n1#3:121\n*S KotlinDebug\n*F\n+ 1 SyntheticBrowserTestBuilder.kt\ncom/personio/synthetics/builder/SyntheticBrowserTestBuilder\n*L\n75#1:113\n75#1:114,3\n87#1:117\n87#1:118,3\n*E\n"})
public final class SyntheticBrowserTestBuilder
extends SyntheticTestBuilder {
    @NotNull
    private final String name;
    @NotNull
    private final SyntheticsBrowserTestConfig config;

    public SyntheticBrowserTestBuilder(@NotNull String name, @NotNull Defaults defaults, @NotNull SyntheticsApiClient apiClient) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)defaults, (String)"defaults");
        Intrinsics.checkNotNullParameter((Object)((Object)apiClient), (String)"apiClient");
        super(name, defaults, apiClient);
        this.name = name;
        this.config = new SyntheticsBrowserTestConfig();
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public final SyntheticsBrowserTest build() {
        SyntheticsBrowserTest syntheticsBrowserTest = new SyntheticsBrowserTest(this.config, this.getParameters().getLocations(), this.getParameters().getMessage(), this.getName(), this.getOptions(), SyntheticsBrowserTestType.BROWSER).tags(this.getParameters().getTags()).status(SyntheticsTestPauseStatus.PAUSED);
        Intrinsics.checkNotNullExpressionValue((Object)syntheticsBrowserTest, (String)"status(...)");
        return syntheticsBrowserTest;
    }

    public final void baseUrl(@NotNull URL url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        this.config.request(new SyntheticsTestRequest().method("GET").url(url.toString()));
    }

    @Override
    public void testFrequency-LRDsOJo(long frequency) {
        long l = DurationKt.toDuration((int)5, (DurationUnit)DurationUnit.MINUTES);
        if (!(Duration.box-impl((long)frequency).compareTo((Object)Duration.box-impl((long)DurationKt.toDuration((int)7, (DurationUnit)DurationUnit.DAYS))) <= 0 ? 0 <= Duration.box-impl((long)frequency).compareTo((Object)Duration.box-impl((long)l)) : false)) {
            boolean bl = false;
            String string = "Frequency should be between 5 minutes and 7 days.";
            throw new IllegalArgumentException(string.toString());
        }
        this.getOptions().setTickEvery(Long.valueOf(Duration.getInWholeSeconds-impl((long)frequency)));
    }

    /*
     * WARNING - void declaration
     */
    public final void browsersAndDevices(SyntheticsDeviceID ... deviceIds) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)deviceIds, (String)"deviceIds");
        SyntheticsDeviceID[] syntheticsDeviceIDArray = deviceIds;
        SyntheticsTestOptions syntheticsTestOptions = this.getOptions();
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var10_11 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it);
        }
        syntheticsTestOptions.setDeviceIds((List)destination$iv$iv);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated(message="The function is deprecated. Please use `browsersAndDevices` instead.", replaceWith=@ReplaceWith(expression="browsersAndDevices(*deviceIds)", imports={}))
    public final void browserAndDevice(SyntheticsDeviceID ... deviceIds) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)deviceIds, (String)"deviceIds");
        SyntheticsDeviceID[] syntheticsDeviceIDArray = deviceIds;
        SyntheticsTestOptions syntheticsTestOptions = this.getOptions();
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var10_11 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it);
        }
        syntheticsTestOptions.setDeviceIds((List)destination$iv$iv);
    }

    @Override
    protected void addLocalVariable(@NotNull String name, @NotNull String pattern) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        SyntheticsBrowserVariable syntheticsBrowserVariable = new SyntheticsBrowserVariable();
        String string = name.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
        this.config.addVariablesItem(syntheticsBrowserVariable.name(string).type(SyntheticsBrowserVariableType.TEXT).pattern(pattern).example(""));
    }

    @Override
    public void useGlobalVariable(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String string = name.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
        String variableName = string;
        String variableId = this.getGlobalVariableId(variableName);
        if (variableId == null) {
            boolean bl = false;
            String string2 = "The global variable " + name + " to be used in the test doesn't exist in DataDog.";
            throw new IllegalStateException(string2.toString());
        }
        this.config.addVariablesItem(new SyntheticsBrowserVariable().name(variableName).id(variableId).type(SyntheticsBrowserVariableType.GLOBAL));
    }
}

