/*
 * Decompiled with CFR 0.152.
 */
package com.personio.synthetics.builder.api;

import com.datadog.api.client.v1.model.SyntheticsAPIStep;
import com.datadog.api.client.v1.model.SyntheticsAPIStepSubtype;
import com.datadog.api.client.v1.model.SyntheticsAssertion;
import com.datadog.api.client.v1.model.SyntheticsParsingOptions;
import com.datadog.api.client.v1.model.SyntheticsTestOptionsRetry;
import com.datadog.api.client.v1.model.SyntheticsTestRequest;
import com.personio.synthetics.builder.AssertionsBuilder;
import com.personio.synthetics.builder.RequestBuilder;
import com.personio.synthetics.builder.parsing.ParsingOptionsBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u001f\u0010\u0011\u001a\u00020!2\u0017\u0010\"\u001a\u0013\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020!0#\u00a2\u0006\u0002\b$J\u0006\u0010%\u001a\u00020 J'\u0010&\u001a\u00020!2\u0006\u0010'\u001a\u00020\u00032\u0017\u0010\"\u001a\u0013\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020!0#\u00a2\u0006\u0002\b$J\u001f\u0010\u001b\u001a\u00020!2\u0017\u0010\"\u001a\u0013\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020!0#\u00a2\u0006\u0002\b$J \u0010(\u001a\u00020!2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,\u00f8\u0001\u0000\u00a2\u0006\u0004\b-\u0010.R\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u000e\"\u0004\b\u0015\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006/"}, d2={"Lcom/personio/synthetics/builder/api/StepBuilder;", "", "name", "", "requestBuilder", "Lcom/personio/synthetics/builder/RequestBuilder;", "assertionBuilder", "Lcom/personio/synthetics/builder/AssertionsBuilder;", "parsingOptionsBuilder", "Lcom/personio/synthetics/builder/parsing/ParsingOptionsBuilder;", "(Ljava/lang/String;Lcom/personio/synthetics/builder/RequestBuilder;Lcom/personio/synthetics/builder/AssertionsBuilder;Lcom/personio/synthetics/builder/parsing/ParsingOptionsBuilder;)V", "allowFailure", "", "getAllowFailure", "()Z", "setAllowFailure", "(Z)V", "assertions", "", "Lcom/datadog/api/client/v1/model/SyntheticsAssertion;", "isCritical", "setCritical", "getName", "()Ljava/lang/String;", "parsingOptions", "", "Lcom/datadog/api/client/v1/model/SyntheticsParsingOptions;", "request", "Lcom/datadog/api/client/v1/model/SyntheticsTestRequest;", "retryOptions", "Lcom/datadog/api/client/v1/model/SyntheticsTestOptionsRetry;", "step", "Lcom/datadog/api/client/v1/model/SyntheticsAPIStep;", "", "init", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "build", "extract", "variableName", "retry", "retryCount", "", "retryInterval", "Lkotlin/time/Duration;", "retry-HG0u8IE", "(JJ)V", "datadog-synthetic-test-support"})
public final class StepBuilder {
    @NotNull
    private final String name;
    @NotNull
    private final RequestBuilder requestBuilder;
    @NotNull
    private final AssertionsBuilder assertionBuilder;
    @NotNull
    private final ParsingOptionsBuilder parsingOptionsBuilder;
    private boolean allowFailure;
    private boolean isCritical;
    @NotNull
    private SyntheticsTestOptionsRetry retryOptions;
    @NotNull
    private final SyntheticsAPIStep step;
    @Nullable
    private SyntheticsTestRequest request;
    @NotNull
    private List<? extends SyntheticsAssertion> assertions;
    @NotNull
    private final List<SyntheticsParsingOptions> parsingOptions;

    public StepBuilder(@NotNull String name, @NotNull RequestBuilder requestBuilder, @NotNull AssertionsBuilder assertionBuilder, @NotNull ParsingOptionsBuilder parsingOptionsBuilder) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)requestBuilder, (String)"requestBuilder");
        Intrinsics.checkNotNullParameter((Object)assertionBuilder, (String)"assertionBuilder");
        Intrinsics.checkNotNullParameter((Object)parsingOptionsBuilder, (String)"parsingOptionsBuilder");
        this.name = name;
        this.requestBuilder = requestBuilder;
        this.assertionBuilder = assertionBuilder;
        this.parsingOptionsBuilder = parsingOptionsBuilder;
        this.retryOptions = new SyntheticsTestOptionsRetry();
        this.step = new SyntheticsAPIStep();
        this.assertions = CollectionsKt.emptyList();
        this.parsingOptions = new ArrayList();
    }

    public /* synthetic */ StepBuilder(String string, RequestBuilder requestBuilder, AssertionsBuilder assertionsBuilder, ParsingOptionsBuilder parsingOptionsBuilder, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            requestBuilder = new RequestBuilder();
        }
        if ((n & 4) != 0) {
            assertionsBuilder = new AssertionsBuilder();
        }
        if ((n & 8) != 0) {
            parsingOptionsBuilder = new ParsingOptionsBuilder();
        }
        this(string, requestBuilder, assertionsBuilder, parsingOptionsBuilder);
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public final boolean getAllowFailure() {
        return this.allowFailure;
    }

    public final void setAllowFailure(boolean bl) {
        this.allowFailure = bl;
    }

    public final boolean isCritical() {
        return this.isCritical;
    }

    public final void setCritical(boolean bl) {
        this.isCritical = bl;
    }

    @NotNull
    public final SyntheticsAPIStep build() {
        if (this.request == null) {
            throw new IllegalStateException("Request must be provided.");
        }
        if (this.allowFailure) {
            this.step.isCritical(Boolean.valueOf(this.isCritical));
        }
        if (!((Collection)this.parsingOptions).isEmpty()) {
            this.step.extractedValues(this.parsingOptions);
        }
        SyntheticsAPIStep syntheticsAPIStep = this.step.request(this.request).allowFailure(Boolean.valueOf(this.allowFailure)).retry(this.retryOptions).name(this.name).assertions(this.assertions).subtype(SyntheticsAPIStepSubtype.HTTP);
        Intrinsics.checkNotNullExpressionValue((Object)syntheticsAPIStep, (String)"subtype(...)");
        return syntheticsAPIStep;
    }

    public final void request(@NotNull Function1<? super RequestBuilder, Unit> init) {
        Intrinsics.checkNotNullParameter(init, (String)"init");
        RequestBuilder requestBuilder = this.requestBuilder;
        init.invoke((Object)requestBuilder);
        this.request = requestBuilder.build();
    }

    public final void assertions(@NotNull Function1<? super AssertionsBuilder, Unit> init) {
        Intrinsics.checkNotNullParameter(init, (String)"init");
        AssertionsBuilder assertionsBuilder = this.assertionBuilder;
        init.invoke((Object)assertionsBuilder);
        this.assertions = assertionsBuilder.build();
    }

    public final void extract(@NotNull String variableName, @NotNull Function1<? super ParsingOptionsBuilder, Unit> init) {
        Intrinsics.checkNotNullParameter((Object)variableName, (String)"variableName");
        Intrinsics.checkNotNullParameter(init, (String)"init");
        this.parsingOptionsBuilder.variable(variableName);
        ParsingOptionsBuilder parsingOptionsBuilder = this.parsingOptionsBuilder;
        init.invoke((Object)parsingOptionsBuilder);
        SyntheticsParsingOptions options = parsingOptionsBuilder.build();
        if (options != null) {
            this.parsingOptions.add(options);
        }
    }

    public final void retry-HG0u8IE(long retryCount, long retryInterval) {
        if (!(0L <= retryCount ? retryCount < 6L : false)) {
            boolean $i$a$-require-StepBuilder$retry$32 = false;
            String $i$a$-require-StepBuilder$retry$32 = "Step retry count should be between 0 and 5.";
            throw new IllegalArgumentException($i$a$-require-StepBuilder$retry$32.toString());
        }
        long l = DurationKt.toDuration((int)0, (DurationUnit)DurationUnit.SECONDS);
        if (!(Duration.box-impl((long)retryInterval).compareTo((Object)Duration.box-impl((long)DurationKt.toDuration((int)5, (DurationUnit)DurationUnit.SECONDS))) <= 0 ? 0 <= Duration.box-impl((long)retryInterval).compareTo((Object)Duration.box-impl((long)l)) : false)) {
            boolean bl = false;
            String string = "Step retry interval should be between 0 and 5000 milliseconds.";
            throw new IllegalArgumentException(string.toString());
        }
        this.retryOptions.count(Long.valueOf(retryCount)).interval(Double.valueOf(Duration.getInWholeMilliseconds-impl((long)retryInterval)));
    }
}

