/*
 * Decompiled with CFR 0.152.
 */
package com.personio.synthetics.builder;

import com.datadog.api.client.v1.model.SyntheticsBrowserTest;
import com.datadog.api.client.v1.model.SyntheticsBrowserTestConfig;
import com.datadog.api.client.v1.model.SyntheticsBrowserTestType;
import com.datadog.api.client.v1.model.SyntheticsBrowserVariable;
import com.datadog.api.client.v1.model.SyntheticsBrowserVariableType;
import com.datadog.api.client.v1.model.SyntheticsDeviceID;
import com.datadog.api.client.v1.model.SyntheticsStep;
import com.datadog.api.client.v1.model.SyntheticsTestOptions;
import com.datadog.api.client.v1.model.SyntheticsTestPauseStatus;
import com.datadog.api.client.v1.model.SyntheticsTestRequest;
import com.personio.synthetics.builder.SyntheticTestBuilder;
import com.personio.synthetics.builder.browser.StepsBuilder;
import com.personio.synthetics.client.SyntheticsApiClient;
import com.personio.synthetics.config.Defaults;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u0017\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0019H\u0016\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u001f\u0010\u001c\u001a\u00020\u00142\u0012\u0010\u001d\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001f0\u001e\"\u00020\u001f\u00a2\u0006\u0002\u0010 J!\u0010!\u001a\u00020\u00142\u0012\u0010\u001d\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001f0\u001e\"\u00020\u001fH\u0007\u00a2\u0006\u0002\u0010 J)\u0010\u000e\u001a\u00020\u00142\b\b\u0002\u0010\"\u001a\u00020#2\u0017\u0010$\u001a\u0013\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020\u00140%\u00a2\u0006\u0002\b&J\u0018\u0010'\u001a\u00020\u00142\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010(\u001a\u00020\u0003H\u0014J\u0010\u0010)\u001a\u00020\u00142\u0006\u0010\u0002\u001a\u00020\u0003H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/personio/synthetics/builder/SyntheticBrowserTestBuilder;", "Lcom/personio/synthetics/builder/SyntheticTestBuilder;", "name", "", "defaults", "Lcom/personio/synthetics/config/Defaults;", "apiClient", "Lcom/personio/synthetics/client/SyntheticsApiClient;", "<init>", "(Ljava/lang/String;Lcom/personio/synthetics/config/Defaults;Lcom/personio/synthetics/client/SyntheticsApiClient;)V", "getName", "()Ljava/lang/String;", "config", "Lcom/datadog/api/client/v1/model/SyntheticsBrowserTestConfig;", "steps", "", "Lcom/datadog/api/client/v1/model/SyntheticsStep;", "build", "Lcom/datadog/api/client/v1/model/SyntheticsBrowserTest;", "baseUrl", "", "url", "Ljava/net/URL;", "testFrequency", "frequency", "Lkotlin/time/Duration;", "testFrequency-LRDsOJo", "(J)V", "browsersAndDevices", "deviceIds", "", "Lcom/datadog/api/client/v1/model/SyntheticsDeviceID;", "([Lcom/datadog/api/client/v1/model/SyntheticsDeviceID;)V", "browserAndDevice", "stepsBuilder", "Lcom/personio/synthetics/builder/browser/StepsBuilder;", "init", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "addLocalVariable", "pattern", "useGlobalVariable", "datadog-synthetic-test-support"})
@SourceDebugExtension(value={"SMAP\nSyntheticBrowserTestBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SyntheticBrowserTestBuilder.kt\ncom/personio/synthetics/builder/SyntheticBrowserTestBuilder\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,132:1\n11158#2:133\n11493#2,3:134\n11158#2:137\n11493#2,3:138\n1#3:141\n*S KotlinDebug\n*F\n+ 1 SyntheticBrowserTestBuilder.kt\ncom/personio/synthetics/builder/SyntheticBrowserTestBuilder\n*L\n85#1:133\n85#1:134,3\n97#1:137\n97#1:138,3\n*E\n"})
public final class SyntheticBrowserTestBuilder
extends SyntheticTestBuilder {
    @NotNull
    private final String name;
    @NotNull
    private final SyntheticsBrowserTestConfig config;
    @NotNull
    private List<SyntheticsStep> steps;

    public SyntheticBrowserTestBuilder(@NotNull String name, @NotNull Defaults defaults, @NotNull SyntheticsApiClient apiClient) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)defaults, (String)"defaults");
        Intrinsics.checkNotNullParameter((Object)((Object)apiClient), (String)"apiClient");
        super(name, defaults, apiClient);
        this.name = name;
        this.config = new SyntheticsBrowserTestConfig();
        this.steps = new ArrayList();
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public final SyntheticsBrowserTest build() {
        SyntheticsBrowserTest test = new SyntheticsBrowserTest(this.config, this.getParameters().getLocations(), this.getParameters().getMessage(), this.getName(), this.getOptions(), SyntheticsBrowserTestType.BROWSER).steps(this.steps).tags(this.getParameters().getTags());
        SyntheticsTestPauseStatus syntheticsTestPauseStatus = this.getStatus();
        if (syntheticsTestPauseStatus != null) {
            SyntheticsTestPauseStatus it = syntheticsTestPauseStatus;
            boolean bl = false;
            test.status(it);
        }
        Intrinsics.checkNotNull((Object)test);
        return test;
    }

    public final void baseUrl(@NotNull URL url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        this.config.request(new SyntheticsTestRequest().method("GET").url(url.toString()));
    }

    @Override
    public void testFrequency-LRDsOJo(long frequency) {
        long l = DurationKt.toDuration((int)5, (DurationUnit)DurationUnit.MINUTES);
        if (!(((Comparable)Duration.box-impl((long)frequency)).compareTo(Duration.box-impl((long)DurationKt.toDuration((int)7, (DurationUnit)DurationUnit.DAYS))) <= 0 ? 0 <= ((Comparable)Duration.box-impl((long)frequency)).compareTo(Duration.box-impl((long)l)) : false)) {
            boolean bl = false;
            String string = "Frequency should be between 5 minutes and 7 days.";
            throw new IllegalArgumentException(string.toString());
        }
        this.getOptions().setTickEvery(Long.valueOf(Duration.getInWholeSeconds-impl((long)frequency)));
    }

    /*
     * WARNING - void declaration
     */
    public final void browsersAndDevices(SyntheticsDeviceID ... deviceIds) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)deviceIds, (String)"deviceIds");
        SyntheticsDeviceID[] syntheticsDeviceIDArray = deviceIds;
        SyntheticsTestOptions syntheticsTestOptions = this.getOptions();
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var10_11 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it);
        }
        syntheticsTestOptions.setDeviceIds((List)destination$iv$iv);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated(message="The function is deprecated. Please use `browsersAndDevices` instead.", replaceWith=@ReplaceWith(expression="browsersAndDevices(*deviceIds)", imports={}))
    public final void browserAndDevice(SyntheticsDeviceID ... deviceIds) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)deviceIds, (String)"deviceIds");
        SyntheticsDeviceID[] syntheticsDeviceIDArray = deviceIds;
        SyntheticsTestOptions syntheticsTestOptions = this.getOptions();
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var10_11 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it);
        }
        syntheticsTestOptions.setDeviceIds((List)destination$iv$iv);
    }

    public final void steps(@NotNull StepsBuilder stepsBuilder, @NotNull Function1<? super StepsBuilder, Unit> init) {
        Intrinsics.checkNotNullParameter((Object)stepsBuilder, (String)"stepsBuilder");
        Intrinsics.checkNotNullParameter(init, (String)"init");
        StepsBuilder stepsBuilder2 = stepsBuilder;
        init.invoke((Object)stepsBuilder2);
        this.steps = CollectionsKt.toMutableList((Collection)stepsBuilder2.build());
    }

    public static /* synthetic */ void steps$default(SyntheticBrowserTestBuilder syntheticBrowserTestBuilder, StepsBuilder stepsBuilder, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            stepsBuilder = new StepsBuilder();
        }
        syntheticBrowserTestBuilder.steps(stepsBuilder, (Function1<? super StepsBuilder, Unit>)function1);
    }

    @Override
    protected void addLocalVariable(@NotNull String name, @NotNull String pattern) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        SyntheticsBrowserVariable syntheticsBrowserVariable = new SyntheticsBrowserVariable();
        String string = name.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
        this.config.addVariablesItem(syntheticsBrowserVariable.name(string).type(SyntheticsBrowserVariableType.TEXT).pattern(pattern).example(""));
    }

    @Override
    public void useGlobalVariable(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String string = name.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
        String variableName = string;
        String variableId = this.getGlobalVariableId(variableName);
        if (variableId == null) {
            boolean bl = false;
            String string2 = "The global variable " + name + " to be used in the test doesn't exist in DataDog.";
            throw new IllegalStateException(string2.toString());
        }
        this.config.addVariablesItem(new SyntheticsBrowserVariable().name(variableName).id(variableId).type(SyntheticsBrowserVariableType.GLOBAL));
    }
}

