/*
 * Decompiled with CFR 0.152.
 */
package com.personio.synthetics.builder.api;

import com.datadog.api.client.v1.model.SyntheticsAPIStep;
import com.datadog.api.client.v1.model.SyntheticsAPITestStep;
import com.datadog.api.client.v1.model.SyntheticsAPITestStepSubtype;
import com.datadog.api.client.v1.model.SyntheticsAPIWaitStep;
import com.datadog.api.client.v1.model.SyntheticsAPIWaitStepSubtype;
import com.datadog.api.client.v1.model.SyntheticsAssertion;
import com.datadog.api.client.v1.model.SyntheticsParsingOptions;
import com.datadog.api.client.v1.model.SyntheticsTestOptionsRetry;
import com.datadog.api.client.v1.model.SyntheticsTestRequest;
import com.personio.synthetics.builder.AssertionsBuilder;
import com.personio.synthetics.builder.RequestBuilder;
import com.personio.synthetics.builder.parsing.ParsingOptionsBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0006\u0010%\u001a\u00020\u0019J\b\u0010&\u001a\u00020\u0019H\u0002J\b\u0010'\u001a\u00020\u0019H\u0002J\u001f\u0010\u001a\u001a\u00020(2\u0017\u0010)\u001a\u0013\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020(0*\u00a2\u0006\u0002\b+J\u001f\u0010\u001f\u001a\u00020(2\u0017\u0010)\u001a\u0013\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020(0*\u00a2\u0006\u0002\b+J'\u0010,\u001a\u00020(2\u0006\u0010-\u001a\u00020\u00032\u0017\u0010)\u001a\u0013\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020(0*\u00a2\u0006\u0002\b+J\u001d\u0010.\u001a\u00020(2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u000202\u00a2\u0006\u0004\b3\u00104J\u0015\u00105\u001a\u00020(2\u0006\u00106\u001a\u000202\u00a2\u0006\u0004\b7\u00108R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0011\"\u0004\b\u0015\u0010\u0013R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u001eR\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lcom/personio/synthetics/builder/api/StepBuilder;", "", "name", "", "requestBuilder", "Lcom/personio/synthetics/builder/RequestBuilder;", "assertionBuilder", "Lcom/personio/synthetics/builder/AssertionsBuilder;", "parsingOptionsBuilder", "Lcom/personio/synthetics/builder/parsing/ParsingOptionsBuilder;", "<init>", "(Ljava/lang/String;Lcom/personio/synthetics/builder/RequestBuilder;Lcom/personio/synthetics/builder/AssertionsBuilder;Lcom/personio/synthetics/builder/parsing/ParsingOptionsBuilder;)V", "getName", "()Ljava/lang/String;", "allowFailure", "", "getAllowFailure", "()Z", "setAllowFailure", "(Z)V", "isCritical", "setCritical", "retryOptions", "Lcom/datadog/api/client/v1/model/SyntheticsTestOptionsRetry;", "step", "Lcom/datadog/api/client/v1/model/SyntheticsAPIStep;", "request", "Lcom/datadog/api/client/v1/model/SyntheticsTestRequest;", "waitDuration", "", "Ljava/lang/Integer;", "assertions", "", "Lcom/datadog/api/client/v1/model/SyntheticsAssertion;", "parsingOptions", "", "Lcom/datadog/api/client/v1/model/SyntheticsParsingOptions;", "build", "buildWaitStep", "buildRequestStep", "", "init", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "extract", "variableName", "retry", "retryCount", "", "retryInterval", "Lkotlin/time/Duration;", "retry-HG0u8IE", "(JJ)V", "wait", "duration", "wait-LRDsOJo", "(J)V", "datadog-synthetic-test-support"})
public final class StepBuilder {
    @NotNull
    private final String name;
    @NotNull
    private final RequestBuilder requestBuilder;
    @NotNull
    private final AssertionsBuilder assertionBuilder;
    @NotNull
    private final ParsingOptionsBuilder parsingOptionsBuilder;
    private boolean allowFailure;
    private boolean isCritical;
    @NotNull
    private SyntheticsTestOptionsRetry retryOptions;
    @NotNull
    private final SyntheticsAPIStep step;
    @Nullable
    private SyntheticsTestRequest request;
    @Nullable
    private Integer waitDuration;
    @NotNull
    private List<? extends SyntheticsAssertion> assertions;
    @NotNull
    private final List<SyntheticsParsingOptions> parsingOptions;

    public StepBuilder(@NotNull String name, @NotNull RequestBuilder requestBuilder, @NotNull AssertionsBuilder assertionBuilder, @NotNull ParsingOptionsBuilder parsingOptionsBuilder) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)requestBuilder, (String)"requestBuilder");
        Intrinsics.checkNotNullParameter((Object)assertionBuilder, (String)"assertionBuilder");
        Intrinsics.checkNotNullParameter((Object)parsingOptionsBuilder, (String)"parsingOptionsBuilder");
        this.name = name;
        this.requestBuilder = requestBuilder;
        this.assertionBuilder = assertionBuilder;
        this.parsingOptionsBuilder = parsingOptionsBuilder;
        this.retryOptions = new SyntheticsTestOptionsRetry();
        this.step = new SyntheticsAPIStep(new SyntheticsAPITestStep());
        this.assertions = CollectionsKt.emptyList();
        this.parsingOptions = new ArrayList();
    }

    public /* synthetic */ StepBuilder(String string, RequestBuilder requestBuilder, AssertionsBuilder assertionsBuilder, ParsingOptionsBuilder parsingOptionsBuilder, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            requestBuilder = new RequestBuilder();
        }
        if ((n & 4) != 0) {
            assertionsBuilder = new AssertionsBuilder();
        }
        if ((n & 8) != 0) {
            parsingOptionsBuilder = new ParsingOptionsBuilder();
        }
        this(string, requestBuilder, assertionsBuilder, parsingOptionsBuilder);
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public final boolean getAllowFailure() {
        return this.allowFailure;
    }

    public final void setAllowFailure(boolean bl) {
        this.allowFailure = bl;
    }

    public final boolean isCritical() {
        return this.isCritical;
    }

    public final void setCritical(boolean bl) {
        this.isCritical = bl;
    }

    @NotNull
    public final SyntheticsAPIStep build() {
        if (this.request == null && this.waitDuration == null) {
            throw new IllegalStateException("Provide either of Request or Wait duration.");
        }
        if (this.request != null && this.waitDuration != null) {
            throw new IllegalStateException("Only one of Request or Wait duration should be provided.");
        }
        if (this.allowFailure) {
            this.step.getSyntheticsAPITestStep().isCritical(Boolean.valueOf(this.isCritical));
        }
        if (!((Collection)this.parsingOptions).isEmpty()) {
            this.step.getSyntheticsAPITestStep().extractedValues(this.parsingOptions);
        }
        return this.waitDuration != null ? this.buildWaitStep() : this.buildRequestStep();
    }

    private final SyntheticsAPIStep buildWaitStep() {
        return new SyntheticsAPIStep(new SyntheticsAPIWaitStep().name(this.name).subtype(SyntheticsAPIWaitStepSubtype.WAIT).value(this.waitDuration));
    }

    private final SyntheticsAPIStep buildRequestStep() {
        return new SyntheticsAPIStep(this.step.getSyntheticsAPITestStep().request(this.request).allowFailure(Boolean.valueOf(this.allowFailure)).retry(this.retryOptions).name(this.name).assertions(this.assertions).subtype(SyntheticsAPITestStepSubtype.HTTP));
    }

    public final void request(@NotNull Function1<? super RequestBuilder, Unit> init) {
        Intrinsics.checkNotNullParameter(init, (String)"init");
        RequestBuilder requestBuilder = this.requestBuilder;
        init.invoke((Object)requestBuilder);
        this.request = requestBuilder.build();
    }

    public final void assertions(@NotNull Function1<? super AssertionsBuilder, Unit> init) {
        Intrinsics.checkNotNullParameter(init, (String)"init");
        AssertionsBuilder assertionsBuilder = this.assertionBuilder;
        init.invoke((Object)assertionsBuilder);
        this.assertions = assertionsBuilder.build();
    }

    public final void extract(@NotNull String variableName, @NotNull Function1<? super ParsingOptionsBuilder, Unit> init) {
        Intrinsics.checkNotNullParameter((Object)variableName, (String)"variableName");
        Intrinsics.checkNotNullParameter(init, (String)"init");
        this.parsingOptionsBuilder.variable(variableName);
        ParsingOptionsBuilder parsingOptionsBuilder = this.parsingOptionsBuilder;
        init.invoke((Object)parsingOptionsBuilder);
        SyntheticsParsingOptions options = parsingOptionsBuilder.build();
        if (options != null) {
            this.parsingOptions.add(options);
        }
    }

    public final void retry-HG0u8IE(long retryCount, long retryInterval) {
        if (!(0L <= retryCount ? retryCount < 6L : false)) {
            boolean $i$a$-require-StepBuilder$retry$32 = false;
            String $i$a$-require-StepBuilder$retry$32 = "Step retry count should be between 0 and 5.";
            throw new IllegalArgumentException($i$a$-require-StepBuilder$retry$32.toString());
        }
        long l = DurationKt.toDuration((int)0, (DurationUnit)DurationUnit.SECONDS);
        if (!(((Comparable)Duration.box-impl((long)retryInterval)).compareTo(Duration.box-impl((long)DurationKt.toDuration((int)5, (DurationUnit)DurationUnit.SECONDS))) <= 0 ? 0 <= ((Comparable)Duration.box-impl((long)retryInterval)).compareTo(Duration.box-impl((long)l)) : false)) {
            boolean bl = false;
            String string = "Step retry interval should be between 0 and 5000 milliseconds.";
            throw new IllegalArgumentException(string.toString());
        }
        this.retryOptions.count(Long.valueOf(retryCount)).interval(Double.valueOf(Duration.getInWholeMilliseconds-impl((long)retryInterval)));
    }

    public final void wait-LRDsOJo(long duration) {
        long l = DurationKt.toDuration((int)1, (DurationUnit)DurationUnit.SECONDS);
        if (!(((Comparable)Duration.box-impl((long)duration)).compareTo(Duration.box-impl((long)DurationKt.toDuration((int)180, (DurationUnit)DurationUnit.SECONDS))) <= 0 ? 0 <= ((Comparable)Duration.box-impl((long)duration)).compareTo(Duration.box-impl((long)l)) : false)) {
            boolean bl = false;
            String string = "Wait duration should be between 1 and 180 seconds.";
            throw new IllegalArgumentException(string.toString());
        }
        this.waitDuration = (int)Duration.getInWholeSeconds-impl((long)duration);
    }
}

