/*
 * Decompiled with CFR 0.152.
 */
package com.personio.synthetics.dsl;

import com.datadog.api.client.v1.model.SyntheticsAPITest;
import com.datadog.api.client.v1.model.SyntheticsBrowserTest;
import com.datadog.api.client.v1.model.SyntheticsTestDetails;
import com.personio.synthetics.builder.SyntheticBrowserTestBuilder;
import com.personio.synthetics.builder.SyntheticMultiStepApiTestBuilder;
import com.personio.synthetics.client.AwsSecretsManagerCredentialsProvider;
import com.personio.synthetics.client.ConfigCredentialsProvider;
import com.personio.synthetics.client.CredentialsProvider;
import com.personio.synthetics.client.SyntheticsApiClient;
import com.personio.synthetics.config.Configuration;
import com.personio.synthetics.config.ConfigurationLoaderKt;
import com.personio.synthetics.config.Credentials;
import com.personio.synthetics.config.Defaults;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000F\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0014\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001H\u0002\u001a'\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0017\u0010\b\u001a\u0013\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t\u00a2\u0006\u0002\b\f\u001a'\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\u0017\u0010\b\u001a\u0013\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000b0\t\u00a2\u0006\u0002\b\f\u001a\u001a\u0010\u0010\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u00a8\u0006\u0016"}, d2={"getSyntheticsApiClientAndDefaults", "Lkotlin/Pair;", "Lcom/personio/synthetics/client/SyntheticsApiClient;", "Lcom/personio/synthetics/config/Defaults;", "syntheticMultiStepApiTest", "Lcom/datadog/api/client/v1/model/SyntheticsAPITest;", "name", "", "init", "Lkotlin/Function1;", "Lcom/personio/synthetics/builder/SyntheticMultiStepApiTestBuilder;", "", "Lkotlin/ExtensionFunctionType;", "syntheticBrowserTest", "Lcom/datadog/api/client/v1/model/SyntheticsBrowserTest;", "Lcom/personio/synthetics/builder/SyntheticBrowserTestBuilder;", "getTestId", "syntheticsApiClient", "getCredentialsProvider", "Lcom/personio/synthetics/client/CredentialsProvider;", "credentials", "Lcom/personio/synthetics/config/Credentials;", "datadog-synthetic-test-support"})
@SourceDebugExtension(value={"SMAP\nSyntheticTestDsl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SyntheticTestDsl.kt\ncom/personio/synthetics/dsl/SyntheticTestDslKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,93:1\n1#2:94\n*E\n"})
public final class SyntheticTestDslKt {
    private static final Pair<SyntheticsApiClient, Defaults> getSyntheticsApiClientAndDefaults() {
        Configuration configuration = ConfigurationLoaderKt.getConfigFromFile("configuration.yaml");
        return TuplesKt.to((Object)((Object)new SyntheticsApiClient(SyntheticTestDslKt.getCredentialsProvider(configuration.getCredentials()), configuration.getDatadogApiHost())), (Object)configuration.getDefaults());
    }

    @NotNull
    public static final SyntheticsAPITest syntheticMultiStepApiTest(@NotNull String name, @NotNull Function1<? super SyntheticMultiStepApiTestBuilder, Unit> init) {
        SyntheticsAPITest syntheticsAPITest;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(init, (String)"init");
        if (!(!StringsKt.isBlank((CharSequence)name))) {
            boolean $i$a$-check-SyntheticTestDslKt$syntheticMultiStepApiTest$22 = false;
            String $i$a$-check-SyntheticTestDslKt$syntheticMultiStepApiTest$22 = "The test's name must not be empty.";
            throw new IllegalStateException($i$a$-check-SyntheticTestDslKt$syntheticMultiStepApiTest$22.toString());
        }
        Pair<SyntheticsApiClient, Defaults> pair = SyntheticTestDslKt.getSyntheticsApiClientAndDefaults();
        SyntheticsApiClient client = (SyntheticsApiClient)((Object)pair.component1());
        Defaults defaults = (Defaults)pair.component2();
        SyntheticMultiStepApiTestBuilder syntheticMultiStepApiTestBuilder = new SyntheticMultiStepApiTestBuilder(name, defaults, client);
        init.invoke((Object)syntheticMultiStepApiTestBuilder);
        SyntheticsAPITest test = syntheticMultiStepApiTestBuilder.build();
        String testId = SyntheticTestDslKt.getTestId(client, name);
        if (testId != null) {
            SyntheticsAPITest syntheticsAPITest2 = client.updateAPITest(testId, test);
            Intrinsics.checkNotNull((Object)syntheticsAPITest2);
            syntheticsAPITest = syntheticsAPITest2;
        } else {
            SyntheticsAPITest syntheticsAPITest3 = client.createSyntheticsAPITest(test);
            Intrinsics.checkNotNull((Object)syntheticsAPITest3);
            syntheticsAPITest = syntheticsAPITest3;
        }
        return syntheticsAPITest;
    }

    @NotNull
    public static final SyntheticsBrowserTest syntheticBrowserTest(@NotNull String name, @NotNull Function1<? super SyntheticBrowserTestBuilder, Unit> init) {
        SyntheticsBrowserTest syntheticsBrowserTest;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(init, (String)"init");
        if (!(!StringsKt.isBlank((CharSequence)name))) {
            boolean $i$a$-check-SyntheticTestDslKt$syntheticBrowserTest$22 = false;
            String $i$a$-check-SyntheticTestDslKt$syntheticBrowserTest$22 = "The test's name must not be empty.";
            throw new IllegalStateException($i$a$-check-SyntheticTestDslKt$syntheticBrowserTest$22.toString());
        }
        Pair<SyntheticsApiClient, Defaults> pair = SyntheticTestDslKt.getSyntheticsApiClientAndDefaults();
        SyntheticsApiClient client = (SyntheticsApiClient)((Object)pair.component1());
        Defaults defaults = (Defaults)pair.component2();
        SyntheticBrowserTestBuilder syntheticBrowserTestBuilder = new SyntheticBrowserTestBuilder(name, defaults, client);
        init.invoke((Object)syntheticBrowserTestBuilder);
        SyntheticsBrowserTest test = syntheticBrowserTestBuilder.build();
        String testId = SyntheticTestDslKt.getTestId(client, name);
        if (testId != null) {
            SyntheticsBrowserTest syntheticsBrowserTest2 = client.updateBrowserTest(testId, test);
            Intrinsics.checkNotNull((Object)syntheticsBrowserTest2);
            syntheticsBrowserTest = syntheticsBrowserTest2;
        } else {
            SyntheticsBrowserTest syntheticsBrowserTest3 = client.createSyntheticsBrowserTest(test);
            Intrinsics.checkNotNull((Object)syntheticsBrowserTest3);
            syntheticsBrowserTest = syntheticsBrowserTest3;
        }
        return syntheticsBrowserTest;
    }

    private static final String getTestId(SyntheticsApiClient syntheticsApiClient, String name) {
        Object v1;
        block2: {
            List list = syntheticsApiClient.listTests().getTests();
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            Iterable iterable = CollectionsKt.filterNotNull((Iterable)list);
            for (Object t : iterable) {
                SyntheticsTestDetails it = (SyntheticsTestDetails)t;
                boolean bl = false;
                if (!it.getName().equals(name)) continue;
                v1 = t;
                break block2;
            }
            v1 = null;
        }
        SyntheticsTestDetails syntheticsTestDetails = v1;
        return syntheticsTestDetails != null ? syntheticsTestDetails.getPublicId() : null;
    }

    private static final CredentialsProvider getCredentialsProvider(Credentials credentials) {
        CredentialsProvider credentialsProvider;
        Credentials it = credentials;
        boolean bl = false;
        CharSequence charSequence = it.getDatadogCredentialsAwsArn();
        if (!(charSequence == null || charSequence.length() == 0)) {
            credentialsProvider = new AwsSecretsManagerCredentialsProvider(it, null, 2, null);
        } else {
            charSequence = it.getDdApiKey();
            if (!(charSequence == null || charSequence.length() == 0) && !((charSequence = (CharSequence)it.getDdAppKey()) == null || charSequence.length() == 0)) {
                credentialsProvider = new ConfigCredentialsProvider(it);
            } else {
                throw new IllegalStateException("Please set the required config values for credentials in the \"configuration.yaml\" under resources.");
            }
        }
        return credentialsProvider;
    }
}

