/*
 * Decompiled with CFR 0.152.
 */
package personthecat.fresult;

import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jetbrains.annotations.CheckReturnValue;
import personthecat.fresult.BasicResult;
import personthecat.fresult.OptionalResult;
import personthecat.fresult.PartialResult;
import personthecat.fresult.Shorthand;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface PartialOptionalResult<T, E extends Throwable>
extends BasicResult<T, E> {
    public PartialResult<T, E> defaultIfEmpty(Supplier<T> var1);

    public PartialResult<T, E> errIfEmpty(Supplier<E> var1);

    public PartialOptionalResult<T, E> ifEmpty(Runnable var1);

    @CheckReturnValue
    public boolean isErr(Class<? super E> var1);

    @CheckReturnValue
    public boolean isAnyErr();

    public OptionalResult<T, E> ifErr(Consumer<E> var1);

    @CheckReturnValue
    public Optional<Throwable> getAnyErr();

    @CheckReturnValue
    default public Throwable unwrapErr() {
        return this.expectErr("Attempted to unwrap a result with no error.");
    }

    default public void assertEmpty() {
        this.expectEmpty("Wrapper contains a value or error.");
    }

    public void expectEmpty(String var1);

    default public void expectEmpty(String message, Object ... args) {
        this.expectEmpty(Shorthand.f(message, args));
    }

    public Throwable expectErr(String var1);

    default public Throwable expectErr(String message, Object ... args) {
        return this.expectErr(Shorthand.f(message, args));
    }

    default public T orElseThrow() throws Throwable {
        this.throwIfErr();
        return this.unwrap();
    }

    public void throwIfErr() throws Throwable;
}

