/*
 * Decompiled with CFR 0.152.
 */
package personthecat.fresult;

import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jetbrains.annotations.CheckReturnValue;
import personthecat.fresult.PartialOptionalResult;
import personthecat.fresult.Protocol;
import personthecat.fresult.Resolver;
import personthecat.fresult.Result;
import personthecat.fresult.Shorthand;
import personthecat.fresult.functions.ThrowingFunction;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface PartialResult<T, E extends Throwable>
extends PartialOptionalResult<T, E> {
    @Override
    @CheckReturnValue
    public boolean isErr(Class<? super E> var1);

    @Override
    @CheckReturnValue
    public boolean isAnyErr();

    @Override
    public Result<T, E> ifErr(Consumer<E> var1);

    @Override
    @CheckReturnValue
    public Optional<Throwable> getAnyErr();

    @CheckReturnValue
    public <U> U fold(Function<T, U> var1, Function<E, U> var2);

    @CheckReturnValue
    public Result.Value<T, E> resolve(Function<E, T> var1);

    @CheckReturnValue
    public T orElseGet(Function<E, T> var1);

    @CheckReturnValue
    public PartialResult<T, E> orElseTry(ThrowingFunction<E, T, E> var1);

    @CheckReturnValue
    public Result<T, Throwable> orElseTry(Protocol var1, ThrowingFunction<E, T, Throwable> var2);

    @CheckReturnValue
    public Result.Value<T, Throwable> orElseTry(Resolver<T> var1, ThrowingFunction<E, T, Throwable> var2);

    @Override
    @CheckReturnValue
    default public Throwable unwrapErr() {
        return this.expectErr("Attempted to unwrap a result with no error.");
    }

    @Override
    public Throwable expectErr(String var1);

    @Override
    default public Throwable expectErr(String message, Object ... args) {
        return this.expectErr(Shorthand.f(message, args));
    }

    @Override
    default public T orElseThrow() throws Throwable {
        this.throwIfErr();
        return this.unwrap();
    }

    @Override
    public void throwIfErr() throws Throwable;

    @Override
    @Deprecated
    default public PartialResult<T, E> defaultIfEmpty(Supplier<T> defaultGetter) {
        return this;
    }

    @Override
    @Deprecated
    default public PartialResult<T, E> ifEmpty(Runnable f) {
        return this;
    }

    @Override
    @Deprecated
    default public void assertEmpty() {
    }

    @Override
    @Deprecated
    default public void expectEmpty(String message) {
    }

    @Override
    @Deprecated
    default public void expectEmpty(String message, Object ... args) {
    }
}

