/*
 * Decompiled with CFR 0.152.
 */
package com.pessetto.origamismtp;

import com.pessetto.origamismtp.status.StatusListener;
import com.pessetto.origamismtp.threads.ConnectionHandler;
import java.io.IOException;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class OrigamiSMTP {
    private ServerSocket smtpSocket;
    private List<StatusListener> statusListeners;
    private int port;

    public OrigamiSMTP(int port) {
        this.port = port;
        this.statusListeners = new ArrayList<StatusListener>();
    }

    public static void main(String[] args) throws Exception {
        int bindPort = 2525;
        if (args.length == 1) {
            System.out.println("Setting port to " + args[0]);
            bindPort = Integer.parseInt(args[0]);
        } else {
            System.out.println("Default to 2525");
        }
        OrigamiSMTP console = new OrigamiSMTP(bindPort);
        console.startSMTP();
    }

    public void addStatusListener(StatusListener sl) {
        this.statusListeners.add(sl);
    }

    public void closeSMTP() {
        try {
            this.smtpSocket.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void startSMTP() throws BindException {
        try {
            ExecutorService threadPool = Executors.newWorkStealingPool();
            System.setProperty("sun.security.ssl.allowUnsafeRenegotiation", "true");
            System.setProperty("sun.security.ssl.allowLegacyHelloMessages", "true");
            Object ssls = null;
            System.out.println("Starting SMTP");
            InetSocketAddress bindAddress = new InetSocketAddress(this.port);
            this.smtpSocket = new ServerSocket();
            this.smtpSocket.setReuseAddress(true);
            this.smtpSocket.bind(bindAddress);
            System.out.println("Socket Opened");
            this.notifyStarted();
            while (!Thread.interrupted() || !Thread.currentThread().isInterrupted()) {
                System.out.println("AWAIT CONNECTION");
                Socket connectionSocket = this.smtpSocket.accept();
                ConnectionHandler connectionHandler = new ConnectionHandler(connectionSocket);
                threadPool.submit(connectionHandler);
                System.out.println("Connection sent to thread");
            }
            if (Thread.interrupted() || Thread.currentThread().isInterrupted()) {
                this.notifyStopped();
                System.out.println("Quit due to interupted thread");
            }
        }
        catch (BindException ex) {
            this.notifyStopped();
            System.err.println("Could not bind to port");
            throw ex;
        }
        catch (Exception ex) {
            this.notifyStopped();
            System.err.println("Failed to open socket");
            ex.printStackTrace(System.err);
        }
    }

    private void notifyStarted() {
        for (StatusListener listener : this.statusListeners) {
            listener.smtpStarted();
        }
    }

    private void notifyStopped() {
        for (StatusListener listener : this.statusListeners) {
            listener.smtpStopped();
        }
    }
}

