/*
 * Decompiled with CFR 0.152.
 */
package com.pessetto.origamismtp.commandhandlers;

import com.pessetto.origamismtp.commandhandlers.AUTHHandler;
import com.pessetto.origamismtp.commandhandlers.DataHandler;
import com.pessetto.origamismtp.commandhandlers.EHLOHandler;
import com.pessetto.origamismtp.commandhandlers.MAILHandler;
import com.pessetto.origamismtp.commandhandlers.QUITHandler;
import com.pessetto.origamismtp.commandhandlers.RCPTHandler;
import com.pessetto.origamismtp.commandhandlers.RSETHandler;
import com.pessetto.origamismtp.commandhandlers.STARTTLSHandler;
import com.pessetto.origamismtp.filehandlers.EmailHandler;
import com.pessetto.origamismtp.status.AuthStatus;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.util.Scanner;
import javax.net.ssl.SSLSocket;

public class CommandHandler {
    private AUTHHandler auth;
    private DataHandler data;
    private EHLOHandler ehlo;
    private MAILHandler mail;
    private RCPTHandler rcpt;
    private STARTTLSHandler tls;
    private DataOutputStream outToClient;
    private Scanner inFromClient;
    private boolean secure;

    public CommandHandler(DataOutputStream outToClient, Scanner inFromClient) {
        this.outToClient = outToClient;
        this.inFromClient = inFromClient;
        this.secure = false;
    }

    public AuthStatus handleAuth(String fullAuth) {
        if (this.auth == null) {
            this.auth = new AUTHHandler(fullAuth);
        }
        this.handleResponse(this.auth.getResponse());
        return this.auth.getStatus();
    }

    public void handleData() {
        this.data = new DataHandler(this.rcpt);
        this.handleResponse(this.data.getResponse());
        this.data = (DataHandler)this.data.validateOrNullify();
        if (this.data != null) {
            this.data.processMessage(this.inFromClient);
            this.handleResponse(this.data.getResponse());
            EmailHandler emailHandler = new EmailHandler(this.mail, this.rcpt, this.data);
        }
    }

    public void handleEHLO(String fullEHLO) {
        this.ehlo = new EHLOHandler(fullEHLO, this.secure);
        this.handleResponse(this.ehlo.getResponse());
        this.ehlo = (EHLOHandler)this.ehlo.validateOrNullify();
    }

    public void handleMAIL(String fullMAIL) {
        this.mail = new MAILHandler(fullMAIL, this.ehlo);
        this.handleResponse(this.mail.getResponse());
        this.mail = (MAILHandler)this.mail.validateOrNullify();
    }

    public void handleRCPT(String fullCmd) {
        if (this.rcpt == null) {
            this.rcpt = new RCPTHandler(fullCmd, this.mail);
        } else {
            this.rcpt.addAddress(fullCmd);
        }
        this.handleResponse(this.rcpt.getResponse());
        this.rcpt = (RCPTHandler)this.rcpt.validateOrNullify();
    }

    public void handleRSET() {
        RSETHandler rset = new RSETHandler(this.mail, this.rcpt, this.data);
        this.handleResponse(rset.getResponse());
    }

    public SSLSocket handleSTARTTLS(Socket old) throws IOException {
        this.tls = new STARTTLSHandler(old);
        this.handleResponse(this.tls.getResponse());
        SSLSocket ssocket = this.tls.enableTLS(old);
        System.out.println("Secure socket setup");
        this.secure = true;
        return ssocket;
    }

    public void handleQuit() {
        QUITHandler quitH = new QUITHandler(this.outToClient, this.inFromClient);
        this.handleResponse(quitH.getResponse());
    }

    public void handleNotImplemented(String cmd) {
        this.handleResponse("502 Command Not Implemented\r\n");
    }

    public void handleResponse(String response) {
        try {
            System.out.println(response);
            this.outToClient.writeBytes(response);
        }
        catch (IOException e) {
            System.err.println("Fatal Error");
            e.printStackTrace();
        }
    }

    public void setInAndOutFromClient(Scanner in, DataOutputStream out) {
        this.inFromClient = in;
        this.outToClient = out;
    }
}

