/*
 * Decompiled with CFR 0.152.
 */
package com.pessetto.origamismtp.commandhandlers;

import com.pessetto.origamismtp.commandhandlers.interfaces.Validatable;

public class MAILHandler
implements Validatable {
    private String fromEmail;
    private String response;
    private boolean valid = false;

    public MAILHandler(String fullCmd, Validatable ehloHandler) {
        String[] parts = fullCmd.split(" ", 2);
        if (ehloHandler == null) {
            this.response = "503 Invalid Sequence of Commands;  Expected EHLO\r\n";
        } else if (parts.length > 1) {
            if ((parts = parts[1].split(":", 2)).length > 1) {
                this.fromEmail = parts[1];
                this.response = "250 OK\r\n";
                this.valid = true;
            } else {
                this.response = "501 Syntax Error could not seperate from and email given (" + fullCmd + ")" + "\r\n";
                this.valid = false;
            }
        } else {
            this.response = "501 Syntax Error could net seperate cmd and cmdId\r\n";
            this.valid = false;
        }
    }

    @Override
    public String getResponse() {
        return this.response;
    }

    public String getSender() {
        return this.fromEmail;
    }

    @Override
    public Validatable validateOrNullify() {
        if (this.valid) {
            return this;
        }
        return null;
    }
}

