/*
 * Decompiled with CFR 0.152.
 */
package com.pessetto.origamismtp.commandhandlers;

import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Date;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManagerFactory;

public class STARTTLSHandler {
    String response;
    SSLServerSocketFactory socketFactory;
    SSLSocket newSocket;
    SSLContext sslContext;
    KeyStore keyStore;
    KeyStore trustStore;
    KeyManagerFactory keyManagerFactory;
    TrustManagerFactory trustFactory;

    public STARTTLSHandler(Socket old) {
        try {
            this.keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            InputStream ksIs = STARTTLSHandler.class.getClassLoader().getResourceAsStream("keys");
            this.keyStore.load(ksIs, "password".toCharArray());
            if (ksIs != null) {
                ksIs.close();
            }
            this.keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            this.keyManagerFactory.init(this.keyStore, "password".toCharArray());
            InputStream trustStoreIs = STARTTLSHandler.class.getClassLoader().getResourceAsStream("truststore");
            this.trustStore = KeyStore.getInstance("JKS");
            this.trustStore.load(trustStoreIs, "password".toCharArray());
            this.trustFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            this.trustFactory.init(this.trustStore);
            this.sslContext = SSLContext.getInstance("TLSv1.2");
            this.sslContext.init(this.keyManagerFactory.getKeyManagers(), this.trustFactory.getTrustManagers(), null);
            this.response = old instanceof SSLSocket ? "454 TLS not available due to temporary reason: TLS already active" : "220 Ready to start TLS\r\n";
        }
        catch (Exception e) {
            System.err.println("Fatal Error: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public SSLSocket enableTLS(Socket old) throws IOException {
        this.response = null;
        try {
            this.newSocket = (SSLSocket)this.sslContext.getSocketFactory().createSocket(old, null, old.getPort(), false);
            this.newSocket.setEnabledProtocols(this.newSocket.getSupportedProtocols());
            this.newSocket.setEnabledCipherSuites(this.newSocket.getSupportedCipherSuites());
            this.newSocket.setUseClientMode(false);
            Thread.sleep(1000L);
            this.newSocket.startHandshake();
            if (this.newSocket.getNeedClientAuth()) {
                Certificate[] serverCerts = this.newSocket.getSession().getLocalCertificates();
                System.out.println("Checking server certificates");
                Date today = new Date();
                for (Certificate cert : serverCerts) {
                    X509Certificate x509Cert = (X509Certificate)cert;
                    Date notAfter = x509Cert.getNotAfter();
                    Date notBefore = x509Cert.getNotBefore();
                    if (today.after(notAfter)) {
                        System.out.println("Bad certificate: past valid date.");
                        continue;
                    }
                    if (today.before(notBefore)) {
                        System.out.println("Bad certificate: before valid date");
                        continue;
                    }
                    System.out.println("Certifcate appears to have valid date");
                }
            }
            return this.newSocket;
        }
        catch (SSLHandshakeException ex) {
            System.err.println("Handshake failed!");
            System.err.println(ex.getMessage());
            ex.printStackTrace(System.err);
        }
        catch (Exception ex) {
            System.out.println("SSL FAILED");
            ex.printStackTrace(System.err);
        }
        return null;
    }

    public String getResponse() {
        return this.response;
    }
}

