/*
 * Decompiled with CFR 0.152.
 */
package com.pessetto.origamismtp.filehandlers.inbox;

import com.pessetto.origamismtp.constants.Constants;
import com.pessetto.origamismtp.filehandlers.inbox.DeleteMessageListener;
import com.pessetto.origamismtp.filehandlers.inbox.Message;
import com.pessetto.origamismtp.filehandlers.inbox.NewMessageListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class Inbox
implements Serializable {
    private static Inbox instance;
    private static final long serialVersionUID = -1686234852843453027L;
    private LinkedList<Message> messages = new LinkedList();
    private transient List<NewMessageListener> newMessageListeners;
    private transient List<DeleteMessageListener> deleteMessageListeners;

    private Inbox() {
    }

    public void addNewMessageListener(NewMessageListener listener) {
        if (this.newMessageListeners == null) {
            this.newMessageListeners = new ArrayList<NewMessageListener>();
        }
        this.newMessageListeners.add(listener);
    }

    public void addDeleteMessageListener(DeleteMessageListener listener) {
        if (this.deleteMessageListeners == null) {
            this.deleteMessageListeners = new ArrayList<DeleteMessageListener>();
        }
        this.deleteMessageListeners.add(listener);
    }

    public void addMessage(Message msg) {
        if (this.newMessageListeners != null) {
            this.notifyListenersOfNewMessage();
        }
        this.messages.add(0, msg);
        this.serialize();
    }

    public void deleteMessage(int id) {
        this.messages.remove(id);
        if (this.deleteMessageListeners != null) {
            this.notifyListenersOfDeletedMessage(id);
        }
        this.serialize();
    }

    public static Inbox getInstance() {
        if (instance != null) {
            return instance;
        }
        File file = new File(Constants.INBOX_FILE);
        System.out.println("Checking for inbox file: " + Constants.INBOX_FILE);
        if (file.exists()) {
            try {
                System.out.println("Inbox file exists");
                FileInputStream fin = new FileInputStream(file);
                ObjectInputStream oin = new ObjectInputStream(fin);
                instance = (Inbox)oin.readObject();
                oin.close();
                fin.close();
            }
            catch (Exception ex) {
                ex.printStackTrace(System.err);
            }
        } else {
            System.out.println("Inbox file does not exist. Creating new.");
            instance = new Inbox();
        }
        return instance;
    }

    public Message getMessage(int id) {
        return this.messages.get(id);
    }

    public int getMessageCount() {
        return this.messages.size();
    }

    public Message getNewestMessage() {
        if (this.messages.size() == 0) {
            return null;
        }
        return this.messages.get(0);
    }

    private void notifyListenersOfNewMessage() {
        for (NewMessageListener listener : this.newMessageListeners) {
            listener.messageRecieved();
        }
    }

    private void notifyListenersOfDeletedMessage(int index) {
        for (DeleteMessageListener listener : this.deleteMessageListeners) {
            listener.removeEmail(index);
        }
    }

    public void serialize() {
        try {
            File inboxFolder = new File(Constants.INBOX_FOLDER);
            if (!inboxFolder.exists()) {
                inboxFolder.mkdirs();
            }
            File inboxFile = new File(Constants.INBOX_FILE);
            inboxFile.setWritable(true, false);
            FileOutputStream fout = new FileOutputStream(inboxFile);
            ObjectOutputStream oout = new ObjectOutputStream(fout);
            oout.writeObject(this);
            oout.close();
            fout.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

