/*
 * Decompiled with CFR 0.152.
 */
package com.pessetto.origamismtp.filehandlers.inbox;

import com.pessetto.origamismtp.filehandlers.inbox.Attachment;
import com.sun.mail.util.BASE64DecoderStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javafx.beans.property.SimpleBooleanProperty;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.jsoup.Jsoup;

public class Message
implements Serializable {
    private static final long serialVersionUID = -3256213945590604962L;
    private String from;
    private String to;
    private String subject;
    private String message;
    private String plainMessage;
    private String htmlMessage;
    private boolean read = false;
    private transient SimpleBooleanProperty isRead;
    private final LinkedList<Attachment> attachments = new LinkedList();

    public Message() {
        this.isRead = new SimpleBooleanProperty(this.read);
    }

    public SimpleBooleanProperty isRead() {
        if (this.isRead == null) {
            System.out.println("Creating simple boolean set to " + this.read + " for email read");
            this.isRead = new SimpleBooleanProperty(this.read);
        }
        return this.isRead;
    }

    public void setRead(boolean isRead) {
        if (this.isRead == null) {
            System.out.println("Creating simple boolean set to " + this.read + " for email read");
            this.isRead = new SimpleBooleanProperty(this.read);
        }
        System.out.println("Setting message read flag to: " + isRead);
        this.read = isRead;
        this.isRead.set(this.read);
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public String getTo() {
        return this.to;
    }

    public void setTo(String to) {
        this.to = to;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
        this.processMessage();
    }

    public String getHTMLMessage() {
        return this.htmlMessage;
    }

    public String getPlainMessage() {
        return this.plainMessage;
    }

    public void processMessage() {
        System.out.println("Process message");
        try {
            Session session = Session.getDefaultInstance((Properties)new Properties());
            ByteArrayInputStream inputStream = new ByteArrayInputStream(this.message.getBytes());
            MimeMessage mimeMessage = new MimeMessage(session, (InputStream)inputStream);
            if (mimeMessage.isMimeType("text/plain")) {
                this.plainMessage = mimeMessage.getContent().toString();
            } else if (mimeMessage.isMimeType("multipart/*")) {
                MimeMultipart mimeMultipart = (MimeMultipart)mimeMessage.getContent();
                this.processMimeMultipart(mimeMultipart);
            }
            this.subject = mimeMessage.getSubject();
            System.out.println("Message processed");
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
        }
    }

    private byte[] convertByteObjectArrayToPrimativeByteArray(Byte[] array) {
        byte[] bytes = new byte[array.length];
        for (int i = 0; i < array.length; ++i) {
            bytes[i] = array[i];
        }
        return bytes;
    }

    private void processMimeMultipart(MimeMultipart mimeMultipart) throws Exception {
        int count = mimeMultipart.getCount();
        for (int i = 0; i < count; ++i) {
            int intVal;
            String html;
            BodyPart bodyPart = mimeMultipart.getBodyPart(i);
            String fileName = this.getFileName(bodyPart.getContentType());
            if (fileName == null) {
                fileName = bodyPart.getFileName();
            }
            if (fileName == null && bodyPart.isMimeType("text/plain")) {
                if (this.plainMessage == null) {
                    html = (String)bodyPart.getContent();
                    this.plainMessage = Jsoup.parse((String)html).html();
                    continue;
                }
                this.addPlainTextAttachment(bodyPart);
                continue;
            }
            if (fileName == null && bodyPart.isMimeType("text/html")) {
                if (this.htmlMessage == null) {
                    html = (String)bodyPart.getContent();
                    this.htmlMessage = Jsoup.parse((String)html).html();
                    continue;
                }
                this.addPlainTextAttachment(bodyPart);
                continue;
            }
            if (bodyPart.isMimeType("multipart/alternative")) {
                this.processMimeMultipart((MimeMultipart)bodyPart.getContent());
                continue;
            }
            if (bodyPart.isMimeType("text/*")) {
                String content = (String)bodyPart.getContent();
                int size = bodyPart.getSize();
                Attachment attach = new Attachment(fileName, content.getBytes(), size);
                this.attachments.add(attach);
                continue;
            }
            BASE64DecoderStream ds = (BASE64DecoderStream)bodyPart.getContent();
            ArrayList<Byte> contentList = new ArrayList<Byte>();
            while ((intVal = ds.read()) >= 0) {
                byte byteVal = (byte)intVal;
                contentList.add(byteVal);
            }
            int size = contentList.size();
            Byte[] ByteContent = contentList.toArray(new Byte[contentList.size()]);
            byte[] content = this.convertByteObjectArrayToPrimativeByteArray(ByteContent);
            Attachment attach = new Attachment(fileName, content, size);
            this.attachments.add(attach);
        }
    }

    public LinkedList<Attachment> getAttachments() {
        return this.attachments;
    }

    public int getAttachmentCount() {
        return this.attachments.size();
    }

    private String getFileName(String details) {
        Pattern p = Pattern.compile("name=\"(.+?)\"");
        Matcher m = p.matcher(details);
        if (m.find() && m.groupCount() > 0) {
            return m.group(1);
        }
        return null;
    }

    private void addPlainTextAttachment(BodyPart b) {
        try {
            System.out.println("Adding plain text attachment");
            String fileName = this.getFileName(b.getContentType());
            String content = (String)b.getContent();
            int size = b.getSize();
            Attachment attach = new Attachment(fileName, content.getBytes(), size);
            this.attachments.add(attach);
        }
        catch (IOException | MessagingException e) {
            System.err.println("Could not get file name or read file content");
            e.printStackTrace();
        }
    }
}

