/*
 * Decompiled with CFR 0.152.
 */
package com.pessetto.origamismtp.threads;

import com.pessetto.origamismtp.commandhandlers.CommandHandler;
import com.pessetto.origamismtp.status.AuthStatus;
import java.io.DataOutputStream;
import java.net.Socket;
import java.util.Scanner;
import javax.net.ssl.SSLHandshakeException;

public class ConnectionHandler
implements Runnable {
    private Socket connectionSocket;

    public ConnectionHandler(Socket connectionSocket) {
        this.connectionSocket = connectionSocket;
    }

    @Override
    public void run() {
        try {
            DataOutputStream outToClient = new DataOutputStream(this.connectionSocket.getOutputStream());
            Scanner inFromClient = new Scanner(this.connectionSocket.getInputStream());
            CommandHandler commandHandler = new CommandHandler(outToClient, inFromClient);
            inFromClient.useDelimiter("\r\n");
            String welcome = "220 127.0.0.1 SMTP Ready\r\n";
            outToClient.writeBytes(welcome);
            String cmd = "";
            boolean quit = false;
            AuthStatus authStatus = AuthStatus.START;
            while (!Thread.currentThread().isInterrupted() && !quit && (cmd = ConnectionHandler.getFullCmd(inFromClient)) != "QUIT") {
                String cmdId = ConnectionHandler.getCmdIdentifier(cmd).toLowerCase();
                System.out.println(cmd);
                System.out.println("Command Handler auth Status: " + (Object)((Object)authStatus));
                if (authStatus == AuthStatus.CONTINUE) {
                    authStatus = commandHandler.handleAuth(cmd);
                    continue;
                }
                if (cmdId.equals("auth")) {
                    authStatus = commandHandler.handleAuth(cmd);
                    continue;
                }
                if (cmdId.equals("data")) {
                    commandHandler.handleData();
                    continue;
                }
                if (cmdId.equals("ehlo") || cmdId.equals("helo")) {
                    commandHandler.handleEHLO(cmd);
                    continue;
                }
                if (cmdId.equals("mail")) {
                    commandHandler.handleMAIL(cmd);
                    continue;
                }
                if (cmdId.equals("rset") || cmd.equals("reset")) {
                    commandHandler.handleRSET();
                    continue;
                }
                if (cmdId.equals("rcpt")) {
                    commandHandler.handleRCPT(cmd);
                    continue;
                }
                if (cmdId.equals("starttls")) {
                    this.connectionSocket = commandHandler.handleSTARTTLS(this.connectionSocket);
                    outToClient = new DataOutputStream(this.connectionSocket.getOutputStream());
                    inFromClient = new Scanner(this.connectionSocket.getInputStream());
                    commandHandler.setInAndOutFromClient(inFromClient, outToClient);
                    continue;
                }
                if (cmdId.equals("quit")) {
                    commandHandler.handleQuit();
                    quit = true;
                    continue;
                }
                commandHandler.handleNotImplemented(cmd);
            }
        }
        catch (SSLHandshakeException ex) {
            System.out.println("SSL Handshake failed");
            ex.printStackTrace(System.err);
        }
        catch (Exception ex) {
            System.out.println("Client Disconnect");
            System.out.println(ex.getMessage());
            ex.printStackTrace(System.err);
        }
    }

    private static String getFullCmd(Scanner inFromClient) {
        String raw = "QUIT";
        if (inFromClient.hasNextLine()) {
            raw = inFromClient.nextLine();
        }
        return raw;
    }

    private static String getCmdIdentifier(String cmd) {
        String[] parts = cmd.split(" ");
        return parts[0].toLowerCase();
    }
}

