/*
 * Decompiled with CFR 0.152.
 */
package com.peterebeles.autocode;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;

public class AutocodeConcurrent {
    public static String IMPORT_GENERATED = "import javax.annotation.Generated;";
    public static String prefix = "//CONCURRENT_";
    public static String tab = "\t";
    public static String sourceRootName = "java";
    public static String pathRootToTest = "../../test/java";
    public static ConvertString originalToMT = name -> name + "_MT.java";

    public static void convertFile(File original) throws IOException {
        File outputFile = AutocodeConcurrent.determineClassName(original);
        String classNameOld = AutocodeConcurrent.className(original);
        String classNameNew = AutocodeConcurrent.className(outputFile);
        List<String> inputLines = AutocodeConcurrent.readLines(original, StandardCharsets.UTF_8);
        ArrayList<String> outputLines = new ArrayList<String>();
        ArrayList<Macro> macros = new ArrayList<Macro>();
        boolean foundImport = false;
        boolean foundClassDef = false;
        boolean omit = false;
        block24: for (int i = 0; i < inputLines.size(); ++i) {
            String line = inputLines.get(i);
            int where = line.indexOf(prefix);
            if (where < 0) {
                if (!foundImport && !foundClassDef && line.startsWith("import")) {
                    foundImport = true;
                    if (!AutocodeConcurrent.containsStartsWith(IMPORT_GENERATED, inputLines)) {
                        outputLines.add(IMPORT_GENERATED);
                    }
                } else if (!foundClassDef && line.contains("class " + classNameOld)) {
                    foundClassDef = true;
                    if (foundImport) {
                        outputLines.add("@Generated(\"" + AutocodeConcurrent.derivePackagePath(outputFile) + "." + classNameOld + "\")");
                    }
                    line = line.replaceFirst("class " + classNameOld, "class " + classNameNew);
                } else {
                    if (foundImport && line.startsWith("@Generated")) continue;
                    line = line.replace(classNameOld + "(", classNameNew + "(");
                }
                if (omit) continue;
                for (Macro m : macros) {
                    line = line.replace(m.name, m.text);
                }
                outputLines.add(line);
                continue;
            }
            String type = AutocodeConcurrent.readType(line, where + prefix.length());
            String whitespaces = line.substring(0, where);
            int frontLength = where + prefix.length() + type.length();
            String message = line.length() > frontLength ? line.substring(frontLength + 1) : "";
            switch (type) {
                case "CLASS_NAME": {
                    continue block24;
                }
                case "INLINE": {
                    outputLines.add(whitespaces + message);
                    continue block24;
                }
                case "ABOVE": {
                    outputLines.remove(outputLines.size() - 1);
                    outputLines.add(whitespaces + message);
                    continue block24;
                }
                case "BELOW": {
                    outputLines.add(whitespaces + message);
                    ++i;
                    continue block24;
                }
                case "REMOVE_ABOVE": {
                    outputLines.remove(outputLines.size() - 1);
                    continue block24;
                }
                case "REMOVE_BELOW": {
                    ++i;
                    continue block24;
                }
                case "REMOVE_LINE": {
                    continue block24;
                }
                case "OMIT_BEGIN": {
                    omit = true;
                    continue block24;
                }
                case "OMIT_END": {
                    omit = false;
                    continue block24;
                }
                case "MACRO": {
                    String[] words = message.split(" ");
                    if (words.length != 2) {
                        throw new RuntimeException("Expected only two words for the macro. " + message);
                    }
                    Macro m = new Macro();
                    m.name = words[0];
                    m.text = words[1];
                    macros.add(m);
                    continue block24;
                }
                default: {
                    throw new RuntimeException("Unknown: " + type);
                }
            }
        }
        PrintStream out = new PrintStream(outputFile);
        for (int i = 0; i < outputLines.size(); ++i) {
            out.println((String)outputLines.get(i));
        }
        out.close();
        AutocodeConcurrent.createTestIfNotThere(outputFile, sourceRootName, pathRootToTest);
    }

    private static void createTestIfNotThere(File file, String sourceRootName, String pathRootToTest) {
        String fileName = "Test" + file.getName();
        ArrayList<String> packagePath = new ArrayList<String>();
        while (true) {
            if (file.getParentFile() == null) {
                throw new IllegalArgumentException("Problem! Can't find '" + sourceRootName + "' directory");
            }
            String parentName = file.getParentFile().getName();
            file = file.getParentFile();
            if (parentName.equals(sourceRootName)) break;
            packagePath.add(parentName);
        }
        file = new File(file, pathRootToTest);
        for (int i = packagePath.size() - 1; i >= 0; --i) {
            file = new File(file, (String)packagePath.get(i));
        }
        if ((file = new File(file, fileName)).exists()) {
            return;
        }
        AutocodeConcurrent.createTestFile(file.toPath().toAbsolutePath().normalize().toFile());
    }

    private static void createTestFile(File path) {
        if (!path.getParentFile().exists() && !path.getParentFile().mkdirs()) {
            throw new RuntimeException("Failed to create directories. " + path.getAbsolutePath());
        }
        System.out.println("Creating " + path);
        try {
            String className = AutocodeConcurrent.className(path);
            String packagePath = AutocodeConcurrent.derivePackagePath(path);
            PrintStream out = new PrintStream(path);
            out.println("package " + packagePath + ";\n\nimport org.junit.jupiter.api.Test;\n\nimport static org.junit.jupiter.api.Assertions.fail;\n\nclass " + className + " {\n" + tab + "@Test\n" + tab + "void compareToSingle() {\n" + tab + tab + "fail(\"implement\");\n" + tab + "}\n}\n");
            out.close();
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private static String derivePackagePath(File file) {
        ArrayList<String> packagePath = new ArrayList<String>();
        while (true) {
            if (file.getParentFile() == null) {
                throw new IllegalArgumentException("Problem! Can't find java directory");
            }
            String parent = file.getParentFile().getName();
            if (parent.equals("test") || parent.equals("src") || parent.equals("java")) break;
            packagePath.add(parent);
            file = file.getParentFile();
        }
        String output = "";
        for (int i = packagePath.size() - 1; i >= 0; --i) {
            output = output + (String)packagePath.get(i) + ".";
        }
        return output.substring(0, output.length() - 1);
    }

    private static File determineClassName(File original) throws IOException {
        String text = AutocodeConcurrent.readFileToString(original, Charset.forName("UTF-8"));
        if (!text.contains("//CONCURRENT")) {
            throw new IOException("Not a concurrent file");
        }
        String pattern = "//CONCURRENT_CLASS_NAME ";
        int where = text.indexOf(pattern);
        if (where < 0) {
            String name = originalToMT.convert(AutocodeConcurrent.className(original));
            return new File(original.getParent(), name);
        }
        String name = AutocodeConcurrent.readUntilEndOfLine(text, where + pattern.length());
        return new File(original.getParent(), name + ".java");
    }

    private static String readType(String line, int location) {
        int index0 = location;
        while (location < line.length()) {
            char c = line.charAt(location);
            if (Character.isWhitespace(c)) {
                return line.substring(index0, location);
            }
            ++location;
        }
        return line.substring(index0, location);
    }

    private static String readUntilEndOfLine(String text, int location) {
        int index0 = location;
        while (location < text.length()) {
            char c = text.charAt(location);
            if (c == '\r' || c == '\n') {
                return text.substring(index0, location);
            }
            ++location;
        }
        return text.substring(index0, location);
    }

    static String readFileToString(File file, Charset encoding) throws IOException {
        byte[] encoded = Files.readAllBytes(file.toPath());
        return new String(encoded, encoding);
    }

    private static String className(File file) {
        String n = file.getName();
        return n.substring(0, n.length() - 5);
    }

    public static void convertDir(File directory, String include, String exclude) {
        if (!directory.isDirectory()) {
            throw new IllegalArgumentException("Must be a directory: '" + directory.getPath() + "'");
        }
        File[] files = directory.listFiles();
        if (files == null) {
            throw new IllegalArgumentException("No files");
        }
        for (File f : files) {
            String name = f.getName();
            if (!name.matches(include) || name.matches(exclude)) continue;
            try {
                AutocodeConcurrent.convertFile(f);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static List<String> readLines(File file, Charset encoding) throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        try (Stream<String> stream = Files.lines(file.toPath(), encoding);){
            stream.forEach(lines::add);
        }
        return lines;
    }

    public static boolean containsStartsWith(String text, List<String> lines) {
        for (int i = 0; i < lines.size(); ++i) {
            if (!lines.get(i).startsWith(text)) continue;
            return true;
        }
        return false;
    }

    private static class Macro {
        String name;
        String text;

        private Macro() {
        }
    }

    @FunctionalInterface
    public static interface ConvertString {
        public String convert(String var1);
    }
}

