/*
 * Decompiled with CFR 0.152.
 */
package com.peterabeles.autocode;

import com.peterabeles.autocode.AugmentJavaFiles;
import com.peterabeles.autocode.Language;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;

public class ConvertFile32From64 {
    InputStream in;
    PrintStream out;
    List<String> customIgnore = new ArrayList<String>();
    List<Replacement> replacements = new ArrayList<Replacement>();
    List<Replacement> replaceStartsWith = new ArrayList<Replacement>();
    List<Replacement> replacementsAfter = new ArrayList<Replacement>();
    boolean skipFilterOnLine;
    public boolean markAsAutoGenerated = false;
    private Language language = Language.JAVA;

    public ConvertFile32From64(Language language, boolean addDefaultReplacements) {
        if (addDefaultReplacements) {
            if (language == Language.JAVA) {
                this.replacePattern("double", "float");
                this.replacePattern("Double", "Float");
                this.replacePattern("_F64", "_F32");
                this.replaceStartsWith("Math.", "(float)Math.");
                this.replaceStartsWith("-Math.", "(float)-Math.");
                this.replacePatternAfter("FIXED_DOUBLE", "/\\*\\*/double");
            } else if (language == Language.KOTLIN) {
                this.replacePattern("Double", "Float");
                this.replacePattern("_F64", "_F32");
                this.replacePatternAfter("FIXED_DOUBLE", "/\\*\\*/Double");
            }
        }
    }

    public ConvertFile32From64(boolean addDefaultReplacements) {
        this(Language.JAVA, addDefaultReplacements);
    }

    public static String fileNameNoExtension(File f, Language language) {
        int langLength = language.suffix().length() + 1;
        String fileName = f.getName();
        return fileName.substring(0, fileName.length() - langLength);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(File inputFile, File outputFile) throws IOException {
        this.scanForCustomization(inputFile);
        try {
            int n;
            this.in = new FileInputStream(inputFile);
            this.out = new PrintStream(outputFile);
            StringBuilder s = new StringBuilder(1024);
            boolean prevChar = false;
            State state = State.INITIALIZING;
            int totalTokens = 0;
            boolean insideBlockComments = false;
            boolean insideLineComment = false;
            int lineCharacterCount = 0;
            this.skipFilterOnLine = false;
            while ((n = this.in.read()) != -1) {
                if (n == 10 || n == 13) {
                    lineCharacterCount = 0;
                    if (insideLineComment) {
                        insideLineComment = false;
                    }
                } else {
                    ++lineCharacterCount;
                }
                if (Character.isWhitespace((char)n)) {
                    if (prevChar) {
                        boolean skip = false;
                        String token = s.toString();
                        if (insideBlockComments && token.startsWith("*/")) {
                            insideBlockComments = false;
                        }
                        if (!insideBlockComments && !insideLineComment) {
                            if (token.startsWith("/*")) {
                                insideBlockComments = true;
                            } else if (token.startsWith("//")) {
                                insideLineComment = true;
                            }
                        }
                        if (insideLineComment && lineCharacterCount == token.length() + 1 && token.startsWith("//NOFILTER")) {
                            this.skipFilterOnLine = true;
                            skip = true;
                        }
                        if (!skip) {
                            switch (state) {
                                case INITIALIZING: {
                                    if (totalTokens == 0 && token.startsWith("/*")) {
                                        state = State.INSIDE_COPYRIGHT;
                                    } else if (!(insideBlockComments || insideLineComment || token.compareTo("class") != 0 && token.compareTo("interface") != 0)) {
                                        state = State.BEFORE_CLASS_NAME;
                                    }
                                    this.handleToken(token);
                                    break;
                                }
                                case INSIDE_COPYRIGHT: {
                                    if (token.compareTo("*/") == 0) {
                                        state = State.INITIALIZING;
                                    }
                                    this.out.print(token);
                                    break;
                                }
                                case BEFORE_CLASS_NAME: {
                                    state = State.MAIN;
                                    String inputName = ConvertFile32From64.fileNameNoExtension(inputFile, this.language);
                                    String outputName = ConvertFile32From64.fileNameNoExtension(outputFile, this.language);
                                    this.out.print(outputName + token.substring(inputName.length()));
                                    break;
                                }
                                case MAIN: {
                                    this.handleToken(token);
                                }
                            }
                        }
                        s.delete(0, s.length());
                        prevChar = false;
                        ++totalTokens;
                    }
                    this.out.write(n);
                    if (n != 10 && n != 13) continue;
                    this.skipFilterOnLine = false;
                    continue;
                }
                prevChar = true;
                s.append((char)n);
            }
            if (prevChar) {
                this.handleToken(s.toString());
            }
        }
        finally {
            this.out.close();
            this.in.close();
            System.gc();
        }
        if (this.language == Language.JAVA && this.markAsAutoGenerated) {
            this.in = new AugmentJavaFiles().augment(new FileInputStream(outputFile), ConvertFile32From64.fileNameNoExtension(inputFile, this.language));
            FileOutputStream out = new FileOutputStream(outputFile);
            this.copy(this.in, out);
            ((OutputStream)out).close();
        }
    }

    public void scanForCustomization(File inputFile) throws IOException {
        String line;
        this.customIgnore.clear();
        BufferedReader in = new BufferedReader(new FileReader(inputFile));
        while ((line = in.readLine()) != null) {
            String[] words;
            if (!line.startsWith("//CUSTOM") || !(words = line.substring(9).split(" "))[0].equals("ignore")) continue;
            this.customIgnore.add(words[1]);
        }
        in.close();
    }

    public void replacePattern(String pattern, String replacement) {
        this.replacements.add(new Replacement(pattern, replacement));
    }

    public void replaceStartsWith(String pattern, String replacement) {
        this.replaceStartsWith.add(new Replacement(pattern, replacement));
    }

    public void replacePatternAfter(String pattern, String replacement) {
        this.replacementsAfter.add(new Replacement(pattern, replacement));
    }

    private void handleToken(String s) {
        int i;
        boolean ignore = false;
        for (i = 0; i < this.customIgnore.size(); ++i) {
            if (!s.contains(this.customIgnore.get(i))) continue;
            ignore = true;
            break;
        }
        if (!(ignore || this.skipFilterOnLine || s.contains("/**/"))) {
            Replacement r;
            for (i = 0; i < this.replacements.size(); ++i) {
                r = this.replacements.get(i);
                s = s.replaceAll(r.pattern, r.replacement);
            }
            for (i = 0; i < this.replaceStartsWith.size(); ++i) {
                r = this.replaceStartsWith.get(i);
                s = this.replaceStartString(s, r.pattern, r.replacement);
            }
            s = this.handleFloats(s);
            for (i = 0; i < this.replacementsAfter.size(); ++i) {
                r = this.replacementsAfter.get(i);
                s = s.replaceAll(r.pattern, r.replacement);
            }
        }
        this.out.print(s);
        this.out.flush();
    }

    private String handleFloats(String input) {
        String regex = "\\d+\\.+\\d+([eE][-+]?\\d+)?";
        return input.replaceAll(regex, "$0f");
    }

    private String replaceStartString(String input, String from, String to) {
        if (input.startsWith(from)) {
            return to + input.substring(from.length());
        }
        return input;
    }

    void copy(InputStream source, OutputStream target) throws IOException {
        int length;
        byte[] buf = new byte[8192];
        while ((length = source.read(buf)) > 0) {
            target.write(buf, 0, length);
        }
    }

    public Language getLanguage() {
        return this.language;
    }

    public void setLanguage(Language language) {
        this.language = language;
    }

    private static enum State {
        INITIALIZING,
        INSIDE_COPYRIGHT,
        BEFORE_CLASS_NAME,
        MAIN;

    }

    private static class Replacement {
        public String pattern;
        public String replacement;

        public Replacement(String pattern, String replacement) {
            this.pattern = pattern;
            this.replacement = replacement;
        }
    }
}

