/*
 * Decompiled with CFR 0.152.
 */
package com.peterabeles.autocode;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Scanner;

public class AugmentJavaFiles {
    public InputStream augment(InputStream stream, String originalFileName) throws IOException {
        int indexOfImport;
        String content = new Scanner(stream).useDelimiter("\\A").next();
        StringBuilder builder = new StringBuilder(content.length());
        Object packageName = this.extractPackageName(content);
        if (((String)packageName).length() != 0) {
            packageName = (String)packageName + ".";
        }
        if ((indexOfImport = this.findIndexWhereKeywordStartsLine(content, "import")) == -1) {
            indexOfImport = this.findIndexAfterPackage(content);
        }
        builder.append(content, 0, indexOfImport);
        builder.append("import javax.annotation.Generated;\n");
        int indexOfClass = this.findLineWhereClassIsDefined(content, indexOfImport);
        if (content.substring(0, indexOfClass).contains("javax.annotation.Generated")) {
            return new ByteArrayInputStream(content.getBytes(StandardCharsets.UTF_8));
        }
        builder.append(content, indexOfImport, indexOfClass);
        builder.append("@Generated(\"" + (String)packageName + originalFileName + "\")\n");
        builder.append(content, indexOfClass, content.length());
        return new ByteArrayInputStream(builder.toString().getBytes(StandardCharsets.UTF_8));
    }

    private String extractPackageName(String content) throws IOException {
        int idx0 = this.findIndexWhereKeywordStartsLine(content, "package");
        if (idx0 == -1) {
            return "";
        }
        for (int idx1 = idx0 += "package".length() + 1; idx1 < content.length(); ++idx1) {
            if (content.charAt(idx1) != ';') continue;
            return content.substring(idx0, idx1);
        }
        throw new IOException("Couldn't find valid package name");
    }

    private int findIndexWhereKeywordStartsLine(String content, String keyword) throws IOException {
        int loc = 0;
        while (true) {
            if ((loc = content.indexOf(keyword, loc)) == -1) {
                return -1;
            }
            if (loc == 0 || AugmentJavaFiles.isNewLine(content.charAt(loc - 1))) break;
            loc += keyword.length();
        }
        return loc;
    }

    private int findIndexAfterPackage(String content) throws IOException {
        int index = this.findIndexWhereKeywordStartsLine(content, "package");
        if (index == -1) {
            return 0;
        }
        boolean foundNewLine = false;
        while (index < content.length()) {
            if (foundNewLine) {
                if (!AugmentJavaFiles.isNewLine(content.charAt(index))) {
                    return index;
                }
            } else if (AugmentJavaFiles.isNewLine(content.charAt(index))) {
                foundNewLine = true;
            }
            ++index;
        }
        return index;
    }

    private int findLineWhereClassIsDefined(String content, int startIndex) throws IOException {
        int locOfKeyWord;
        int indexInContent;
        int searchClass = content.indexOf("class", startIndex);
        int searchInterface = content.indexOf("interface", startIndex);
        int nextSearch = -1;
        while (true) {
            String keyword;
            if (nextSearch == 1) {
                searchClass = content.indexOf("class", searchClass + 5);
            } else if (nextSearch == 2) {
                searchInterface = content.indexOf("interface", searchInterface + 9);
            }
            if (searchClass < 0 && searchInterface < 0) {
                throw new IOException("Couldn't find valid 'class' or 'interface'");
            }
            if (searchInterface < 0 || searchClass >= 0 && searchClass < searchInterface) {
                keyword = "class";
                indexInContent = searchClass;
                nextSearch = 1;
            } else {
                keyword = "interface";
                indexInContent = searchInterface;
                nextSearch = 2;
            }
            String line = AugmentJavaFiles.extractLine(content, indexInContent);
            String[] words = line.split("\\s+");
            String className = null;
            for (int i = 0; i < words.length - 1; ++i) {
                if (!words[i].equals(keyword)) continue;
                className = words[i + 1];
                break;
            }
            if (className == null) continue;
            locOfKeyWord = line.indexOf(keyword);
            int locOfSlash = line.indexOf("/");
            int locOfStar = line.indexOf("*");
            if (!(locOfSlash != -1 && locOfSlash < locOfKeyWord || locOfStar != -1 && locOfStar < locOfKeyWord)) break;
        }
        return indexInContent - locOfKeyWord;
    }

    private static String extractLine(String content, int seedIndex) {
        int idx1;
        int idx0;
        for (idx0 = Math.max(0, seedIndex - 1); idx0 > 0; --idx0) {
            if (!AugmentJavaFiles.isNewLine(content.charAt(idx0))) continue;
            ++idx0;
            break;
        }
        for (idx1 = Math.min(content.length(), seedIndex + 1); idx1 < content.length() && !AugmentJavaFiles.isNewLine(content.charAt(idx1)); ++idx1) {
        }
        return content.substring(idx0, idx1);
    }

    private static boolean isNewLine(char c) {
        return c == '\n' || c == '\r';
    }
}

