/*
 * Decompiled with CFR 0.152.
 */
package com.peterabeles.autocode;

import com.peterabeles.autocode.ConvertFile32From64;
import com.peterabeles.autocode.Language;
import java.io.File;

public class RecursiveConvert {
    private ConvertFile32From64 converter;
    private String suffice64 = "_F64";
    private String suffice32 = "_F32";
    private Language language = Language.JAVA;

    public RecursiveConvert(ConvertFile32From64 converter) {
        this.converter = converter;
    }

    public void setSuffice(String suffice64, String suffice32) {
        this.suffice64 = suffice64;
        this.suffice32 = suffice32;
    }

    public void process(File inputDirectory) {
        this.process(inputDirectory, inputDirectory);
    }

    public void process(File inputDirectory, File outputDirectory) {
        if (!inputDirectory.isDirectory()) {
            throw new IllegalArgumentException("Not a directory. " + inputDirectory.getPath());
        }
        if (!outputDirectory.exists() && !outputDirectory.mkdirs()) {
            throw new RuntimeException("Can't create output directory. " + outputDirectory.getPath());
        }
        if (!outputDirectory.isDirectory()) {
            throw new IllegalArgumentException("Output isn't a directory. " + outputDirectory.getPath());
        }
        this.converter.setLanguage(this.language);
        System.out.println("---- Directory " + inputDirectory);
        File[] files = inputDirectory.listFiles();
        if (files == null) {
            return;
        }
        String fileEnding64 = this.suffice64 + "." + this.language.suffix();
        String fileEnding32 = this.suffice32 + "." + this.language.suffix();
        int length64 = fileEnding64.length();
        for (File f : files) {
            Object n;
            if (!f.isFile() || !((String)(n = f.getName())).endsWith(fileEnding64)) continue;
            n = ((String)n).substring(0, ((String)n).length() - length64) + fileEnding32;
            try {
                System.out.println("Generating " + (String)n);
                this.converter.process(f, new File(outputDirectory, (String)n));
            }
            catch (Exception e) {
                System.out.println("\n\n\nCode generation failed!");
                e.printStackTrace();
                System.out.flush();
                System.err.flush();
                throw new RuntimeException(e);
            }
        }
        for (File f : files) {
            if (!f.isDirectory() || f.isHidden()) continue;
            this.process(f, new File(outputDirectory, f.getName()));
        }
    }

    public Language getLanguage() {
        return this.language;
    }

    public void setLanguage(Language language) {
        this.language = language;
    }
}

