/*
 * Decompiled with CFR 0.152.
 */
package com.pgssoft.httpclient;

import com.pgssoft.httpclient.HttpClientMockBuilder;
import com.pgssoft.httpclient.HttpClientVerify;
import com.pgssoft.httpclient.MockedServerResponse;
import com.pgssoft.httpclient.NoMatchingRuleException;
import com.pgssoft.httpclient.internal.HttpResponseProxy;
import com.pgssoft.httpclient.internal.debug.Debugger;
import com.pgssoft.httpclient.internal.rule.Rule;
import com.pgssoft.httpclient.internal.rule.RuleBuilder;
import java.io.IOException;
import java.net.Authenticator;
import java.net.CookieHandler;
import java.net.ProxySelector;
import java.net.http.HttpClient;
import java.net.http.HttpHeaders;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.SubmissionPublisher;
import java.util.stream.Collectors;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;

public final class HttpClientMock
extends HttpClient {
    private final Debugger debugger;
    private final List<Rule> rules = new ArrayList<Rule>();
    private final List<RuleBuilder> rulesUnderConstruction = new ArrayList<RuleBuilder>();
    private final String host;
    private final List<HttpRequest> requests = new ArrayList<HttpRequest>();
    private boolean debuggingOn;

    public HttpClientMock() {
        this("");
    }

    public HttpClientMock(String host) {
        this.host = host;
        this.debugger = new Debugger();
    }

    HttpClientMock(String host, Debugger debugger) {
        this.host = host;
        this.debugger = debugger;
    }

    public void reset() {
        this.rulesUnderConstruction.clear();
        this.requests.clear();
    }

    public HttpClientVerify verify() {
        return new HttpClientVerify(this.host, this.requests);
    }

    public HttpClientMockBuilder onPost() {
        return this.newRule("POST");
    }

    public HttpClientMockBuilder onGet() {
        return this.newRule("GET");
    }

    public HttpClientMockBuilder onDelete() {
        return this.newRule("DELETE");
    }

    public HttpClientMockBuilder onHead() {
        return this.newRule("HEAD");
    }

    public HttpClientMockBuilder onOptions() {
        return this.newRule("OPTIONS");
    }

    public HttpClientMockBuilder onPut() {
        return this.newRule("PUT");
    }

    public HttpClientMockBuilder onPatch() {
        return this.newRule("PATCH");
    }

    public HttpClientMockBuilder onGet(String url) {
        Objects.requireNonNull(url, "URL must be not null");
        return this.newRule("GET", url);
    }

    public HttpClientMockBuilder onPost(String url) {
        Objects.requireNonNull(url, "URL must be not null");
        return this.newRule("POST", url);
    }

    public HttpClientMockBuilder onPut(String url) {
        Objects.requireNonNull(url, "URL must be not null");
        return this.newRule("PUT", url);
    }

    public HttpClientMockBuilder onDelete(String url) {
        Objects.requireNonNull(url, "URL must be not null");
        return this.newRule("DELETE", url);
    }

    public HttpClientMockBuilder onHead(String url) {
        Objects.requireNonNull(url, "URL must be not null");
        return this.newRule("HEAD", url);
    }

    public HttpClientMockBuilder onOptions(String url) {
        Objects.requireNonNull(url, "URL must be not null");
        return this.newRule("OPTIONS", url);
    }

    public HttpClientMockBuilder onPatch(String url) {
        Objects.requireNonNull(url, "URL must be not null");
        return this.newRule("PATCH", url);
    }

    private HttpClientMockBuilder newRule(String method) {
        RuleBuilder r = new RuleBuilder(method);
        this.rulesUnderConstruction.add(r);
        return new HttpClientMockBuilder(r);
    }

    private HttpClientMockBuilder newRule(String method, String url) {
        RuleBuilder r = new RuleBuilder(method, this.host, url);
        this.rulesUnderConstruction.add(r);
        return new HttpClientMockBuilder(r);
    }

    @Override
    public Optional<CookieHandler> cookieHandler() {
        return Optional.empty();
    }

    @Override
    public Optional<Duration> connectTimeout() {
        return Optional.empty();
    }

    @Override
    public HttpClient.Redirect followRedirects() {
        return null;
    }

    @Override
    public Optional<ProxySelector> proxy() {
        return Optional.empty();
    }

    @Override
    public SSLContext sslContext() {
        return null;
    }

    @Override
    public SSLParameters sslParameters() {
        return null;
    }

    @Override
    public Optional<Authenticator> authenticator() {
        return Optional.empty();
    }

    @Override
    public HttpClient.Version version() {
        return null;
    }

    @Override
    public Optional<Executor> executor() {
        return Optional.empty();
    }

    @Override
    public <T> HttpResponse<T> send(HttpRequest request, HttpResponse.BodyHandler<T> responseBodyHandler) throws IOException {
        Objects.requireNonNull(request, "request must be not null");
        Objects.requireNonNull(responseBodyHandler, "responseBodyHandler must be not null");
        Rule rule = this.findNextRule(request);
        MockedServerResponse serverResponse = rule.produceResponse();
        T body = this.submitToBodyHandler(serverResponse, responseBodyHandler);
        HttpHeaders httpHeaders = HttpHeaders.of(serverResponse.headers(), (a, b) -> true);
        return new HttpResponseProxy<T>(serverResponse.statusCode(), httpHeaders, body, request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Rule findNextRule(HttpRequest request) {
        List<RuleBuilder> list = this.rulesUnderConstruction;
        synchronized (list) {
            this.rules.addAll(this.rulesUnderConstruction.stream().map(RuleBuilder::build).collect(Collectors.toList()));
            this.rulesUnderConstruction.clear();
        }
        this.requests.add(request);
        Optional<Rule> rule = this.rules.stream().filter(r -> r.matches(request)).reduce((a, b) -> b);
        if (this.debuggingOn || rule.isEmpty()) {
            this.debugger.debug(this.rules, request);
        }
        return rule.orElseThrow(() -> new NoMatchingRuleException(request));
    }

    @Override
    public <T> CompletableFuture<HttpResponse<T>> sendAsync(HttpRequest request, HttpResponse.BodyHandler<T> responseBodyHandler) {
        Objects.requireNonNull(request, "request must be not null");
        Objects.requireNonNull(responseBodyHandler, "responseBodyHandler must be not null");
        try {
            Rule rule = this.findNextRule(request);
            MockedServerResponse serverResponse = rule.produceResponse();
            T body = this.submitToBodyHandler(serverResponse, responseBodyHandler);
            HttpHeaders httpHeaders = HttpHeaders.of(serverResponse.headers(), (a, b) -> true);
            HttpResponseProxy<T> response = new HttpResponseProxy<T>(serverResponse.statusCode(), httpHeaders, body, request);
            return CompletableFuture.completedFuture(response);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public <T> CompletableFuture<HttpResponse<T>> sendAsync(HttpRequest request, HttpResponse.BodyHandler<T> responseBodyHandler, HttpResponse.PushPromiseHandler<T> pushPromiseHandler) {
        return this.sendAsync(request, responseBodyHandler);
    }

    public void debugOn() {
        this.debuggingOn = true;
    }

    public void debugOff() {
        this.debuggingOn = false;
    }

    private <T> T submitToBodyHandler(MockedServerResponse serverResponse, HttpResponse.BodyHandler<T> responseBodyHandler) {
        ByteBuffer bodyBytes = serverResponse.getBodyBytes();
        HttpResponse.BodySubscriber<T> subscriber = responseBodyHandler.apply(this.produceResponseInfo(serverResponse));
        SubmissionPublisher<List<ByteBuffer>> publisher = new SubmissionPublisher<List<ByteBuffer>>();
        publisher.subscribe(subscriber);
        if (bodyBytes.array().length != 0) {
            publisher.submit(List.of(bodyBytes));
        }
        publisher.close();
        try {
            return subscriber.getBody().toCompletableFuture().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new IllegalStateException("Error reading the mocked response body - did you forget to provide it? If there should be no body, try using BodyHandlers.discarding() when making the request", e);
        }
    }

    private HttpResponse.ResponseInfo produceResponseInfo(final MockedServerResponse response) {
        return new HttpResponse.ResponseInfo(){

            @Override
            public int statusCode() {
                return response.statusCode();
            }

            @Override
            public HttpHeaders headers() {
                return HttpHeaders.of(response.headers(), (a, b) -> true);
            }

            @Override
            public HttpClient.Version version() {
                return HttpClient.Version.HTTP_1_1;
            }
        };
    }
}

