/*
 * Decompiled with CFR 0.152.
 */
package com.pgssoft.httpclient;

import com.pgssoft.httpclient.Action;
import com.pgssoft.httpclient.Condition;
import com.pgssoft.httpclient.HttpClientResponseBuilder;
import com.pgssoft.httpclient.internal.condition.BodyCondition;
import com.pgssoft.httpclient.internal.condition.HeaderCondition;
import com.pgssoft.httpclient.internal.rule.RuleBuilder;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Objects;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public final class HttpClientMockBuilder {
    private final RuleBuilder ruleBuilder;
    private final HttpClientResponseBuilder responseBuilder;

    HttpClientMockBuilder(RuleBuilder ruleBuilder) {
        this.ruleBuilder = ruleBuilder;
        this.responseBuilder = new HttpClientResponseBuilder(ruleBuilder);
    }

    public HttpClientMockBuilder withHeader(String header, String value) {
        Objects.requireNonNull(header, "header must be not null");
        return this.withHeader(header, (Matcher<String>)Matchers.equalTo((Object)value));
    }

    public HttpClientMockBuilder withHeader(String header, Matcher<String> matcher) {
        Objects.requireNonNull(header, "header must be not null");
        Objects.requireNonNull(matcher, "matcher must be not null");
        this.ruleBuilder.addCondition(new HeaderCondition(header, matcher));
        return this;
    }

    public HttpClientMockBuilder withReference(String reference) {
        Objects.requireNonNull(reference, "reference must be not null");
        return this.withReference((Matcher<String>)Matchers.equalTo((Object)reference));
    }

    public HttpClientMockBuilder withReference(Matcher<String> matcher) {
        Objects.requireNonNull(matcher, "matcher must be not null");
        this.ruleBuilder.setReferenceCondition(matcher);
        return this;
    }

    public HttpClientMockBuilder withParameter(String name, String value) {
        Objects.requireNonNull(name, "name must be not null");
        Objects.requireNonNull(value, "value must be not null");
        return this.withParameter(name, (Matcher<String>)Matchers.equalTo((Object)value));
    }

    public HttpClientMockBuilder withParameter(String name, Matcher<String> matcher) {
        Objects.requireNonNull(name, "name must be not null");
        Objects.requireNonNull(matcher, "matcher must be not null");
        this.ruleBuilder.setParameterCondition(name, matcher);
        return this;
    }

    public HttpClientMockBuilder with(Condition condition) {
        Objects.requireNonNull(condition, "condition must be not null");
        this.ruleBuilder.addCondition(condition);
        return this;
    }

    public HttpClientMockBuilder withBody(Matcher<String> matcher) {
        Objects.requireNonNull(matcher, "matcher must be not null");
        this.ruleBuilder.addCondition(new BodyCondition(matcher));
        return this;
    }

    public HttpClientMockBuilder withHost(String host) {
        Objects.requireNonNull(host, "host must be not null");
        this.ruleBuilder.addHostCondition(host);
        return this;
    }

    public HttpClientMockBuilder withPath(String path) {
        Objects.requireNonNull(path, "path must be not null");
        return this.withPath((Matcher<String>)Matchers.equalTo((Object)path));
    }

    public HttpClientMockBuilder withPath(Matcher<String> matcher) {
        Objects.requireNonNull(matcher, "matcher must be not null");
        this.ruleBuilder.setPathCondition(matcher);
        return this;
    }

    public HttpClientResponseBuilder doAction(Action action) {
        Objects.requireNonNull(action, "action must be not null");
        return this.responseBuilder.doAction(action);
    }

    public HttpClientResponseBuilder doReturn(String response) {
        Objects.requireNonNull(response, "response must be not null");
        return this.responseBuilder.doReturn(response);
    }

    public HttpClientResponseBuilder doReturn(int statusCode, String response) {
        Objects.requireNonNull(response, "response must be not null");
        return this.responseBuilder.doReturn(statusCode, response);
    }

    public HttpClientResponseBuilder doReturn(String response, Charset charset) {
        Objects.requireNonNull(response, "response must be not null");
        Objects.requireNonNull(charset, "charset must be not null");
        return this.responseBuilder.doReturn(response, charset);
    }

    public HttpClientResponseBuilder doReturnStatus(int statusCode) {
        return this.responseBuilder.doReturnStatus(statusCode);
    }

    public HttpClientResponseBuilder doThrowException(IOException exception) {
        Objects.requireNonNull(exception, "exception must be not null");
        return this.responseBuilder.doThrowException(exception);
    }

    public HttpClientResponseBuilder doReturnJSON(String response) {
        Objects.requireNonNull(response, "response must be not null");
        return this.responseBuilder.doReturnJSON(response);
    }

    public HttpClientResponseBuilder doReturnJSON(String response, Charset charset) {
        Objects.requireNonNull(response, "response must be not null");
        Objects.requireNonNull(charset, "charset must be not null");
        return this.responseBuilder.doReturnJSON(response, charset);
    }

    public HttpClientResponseBuilder doReturnXML(String response) {
        Objects.requireNonNull(response, "response must be not null");
        return this.responseBuilder.doReturnXML(response);
    }

    public HttpClientResponseBuilder doReturnXML(String response, Charset charset) {
        Objects.requireNonNull(response, "response must be not null");
        Objects.requireNonNull(charset, "charset must be not null");
        return this.responseBuilder.doReturnXML(response, charset);
    }
}

