/*
 * Decompiled with CFR 0.152.
 */
package com.pgssoft.httpclient;

import com.pgssoft.httpclient.Action;
import com.pgssoft.httpclient.internal.action.SetBodyStringAction;
import com.pgssoft.httpclient.internal.action.SetHeaderAction;
import com.pgssoft.httpclient.internal.action.SetStatusAction;
import com.pgssoft.httpclient.internal.action.ThrowExceptionAction;
import com.pgssoft.httpclient.internal.rule.RuleBuilder;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public final class HttpClientResponseBuilder {
    private static final String APPLICATION_JSON = "application/json";
    private static final String APPLICATION_XML = "application/xml";
    private final RuleBuilder ruleBuilder;

    HttpClientResponseBuilder(RuleBuilder ruleBuilder) {
        this.ruleBuilder = ruleBuilder;
    }

    public HttpClientResponseBuilder withHeader(String name, String value) {
        return this.doAction(new SetHeaderAction(name, value));
    }

    public HttpClientResponseBuilder withStatus(int statusCode) {
        return this.doAction(new SetStatusAction(statusCode));
    }

    public HttpClientResponseBuilder doAction(Action action) {
        this.ruleBuilder.addAction(action);
        return this;
    }

    public HttpClientResponseBuilder doReturn(String response) {
        return this.doReturn(response, StandardCharsets.UTF_8);
    }

    public HttpClientResponseBuilder doReturn(int statusCode, String response) {
        return this.doReturn(statusCode, response, StandardCharsets.UTF_8);
    }

    public HttpClientResponseBuilder doReturn(String response, Charset charset) {
        return this.doReturn(200, response, charset);
    }

    public HttpClientResponseBuilder doReturn(int statusCode, String response, Charset charset) {
        this.ruleBuilder.addActionBundle(new SetBodyStringAction(response, charset));
        this.ruleBuilder.addAction(new SetStatusAction(statusCode));
        return new HttpClientResponseBuilder(this.ruleBuilder);
    }

    public HttpClientResponseBuilder doReturnStatus(int statusCode) {
        this.ruleBuilder.addActionBundle(new SetStatusAction(statusCode));
        return new HttpClientResponseBuilder(this.ruleBuilder);
    }

    public HttpClientResponseBuilder doThrowException(IOException exception) {
        this.ruleBuilder.addActionBundle(new ThrowExceptionAction(exception));
        return new HttpClientResponseBuilder(this.ruleBuilder);
    }

    public HttpClientResponseBuilder doReturnJSON(String response) {
        return this.doReturnJSON(response, StandardCharsets.UTF_8);
    }

    public HttpClientResponseBuilder doReturnJSON(String response, Charset charset) {
        return this.doReturn(response, charset).withHeader("Content-type", this.buildContentTypeHeader(APPLICATION_JSON, charset));
    }

    public HttpClientResponseBuilder doReturnXML(String response) {
        return this.doReturnXML(response, StandardCharsets.UTF_8);
    }

    public HttpClientResponseBuilder doReturnXML(String response, Charset charset) {
        return this.doReturn(response, charset).withHeader("Content-type", this.buildContentTypeHeader(APPLICATION_XML, charset));
    }

    private String buildContentTypeHeader(String type, Charset charset) {
        return String.format("%s; charset=%s", type, charset.name());
    }
}

