/*
 * Decompiled with CFR 0.152.
 */
package com.pgssoft.httpclient;

import com.pgssoft.httpclient.HttpClientVerifyBuilder;
import com.pgssoft.httpclient.internal.rule.RuleBuilder;
import java.net.http.HttpRequest;
import java.util.List;
import java.util.Objects;

public final class HttpClientVerify {
    private final String defaultHost;
    private final List<HttpRequest> requests;

    HttpClientVerify(String defaultHost, List<HttpRequest> requests) {
        this.requests = requests;
        this.defaultHost = defaultHost;
    }

    private HttpClientVerifyBuilder newRule(String method) {
        RuleBuilder r = new RuleBuilder(method);
        return new HttpClientVerifyBuilder(r, this.requests);
    }

    private HttpClientVerifyBuilder newRule(String method, String url) {
        RuleBuilder r = new RuleBuilder(method, this.defaultHost, url);
        return new HttpClientVerifyBuilder(r, this.requests);
    }

    public HttpClientVerifyBuilder post(String url) {
        Objects.requireNonNull(url, "URL must be not null");
        return this.newRule("POST", url);
    }

    public HttpClientVerifyBuilder get(String url) {
        Objects.requireNonNull(url, "URL must be not null");
        return this.newRule("GET", url);
    }

    public HttpClientVerifyBuilder put(String url) {
        Objects.requireNonNull(url, "URL must be not null");
        return this.newRule("PUT", url);
    }

    public HttpClientVerifyBuilder delete(String url) {
        Objects.requireNonNull(url, "URL must be not null");
        return this.newRule("DELETE", url);
    }

    public HttpClientVerifyBuilder head(String url) {
        Objects.requireNonNull(url, "URL must be not null");
        return this.newRule("HEAD", url);
    }

    public HttpClientVerifyBuilder options(String url) {
        Objects.requireNonNull(url, "URL must be not null");
        return this.newRule("OPTIONS", url);
    }

    public HttpClientVerifyBuilder patch(String url) {
        Objects.requireNonNull(url, "URL must be not null");
        return this.newRule("PATCH", url);
    }

    public HttpClientVerifyBuilder post() {
        return this.newRule("POST");
    }

    public HttpClientVerifyBuilder get() {
        return this.newRule("GET");
    }

    public HttpClientVerifyBuilder put() {
        return this.newRule("PUT");
    }

    public HttpClientVerifyBuilder delete() {
        return this.newRule("DELETE");
    }

    public HttpClientVerifyBuilder head() {
        return this.newRule("HEAD");
    }

    public HttpClientVerifyBuilder options() {
        return this.newRule("OPTIONS");
    }

    public HttpClientVerifyBuilder patch() {
        return this.newRule("PATCH");
    }
}

