/*
 * Decompiled with CFR 0.152.
 */
package com.pgssoft.httpclient;

import com.pgssoft.httpclient.Condition;
import com.pgssoft.httpclient.internal.condition.BodyCondition;
import com.pgssoft.httpclient.internal.condition.HeaderCondition;
import com.pgssoft.httpclient.internal.rule.Rule;
import com.pgssoft.httpclient.internal.rule.RuleBuilder;
import java.net.http.HttpRequest;
import java.util.List;
import java.util.Objects;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public final class HttpClientVerifyBuilder {
    private final RuleBuilder ruleBuilder;
    private final List<HttpRequest> requests;

    HttpClientVerifyBuilder(RuleBuilder ruleBuilder, List<HttpRequest> requests) {
        this.requests = requests;
        this.ruleBuilder = ruleBuilder;
    }

    public HttpClientVerifyBuilder withHeader(String header, String value) {
        Objects.requireNonNull(header, "header must be not null");
        return this.withHeader(header, (Matcher<String>)Matchers.equalTo((Object)value));
    }

    public HttpClientVerifyBuilder withHeader(String header, Matcher<String> matcher) {
        Objects.requireNonNull(header, "header must be not null");
        Objects.requireNonNull(matcher, "matcher must be not null");
        this.ruleBuilder.addCondition(new HeaderCondition(header, matcher));
        return this;
    }

    public HttpClientVerifyBuilder withReference(String reference) {
        Objects.requireNonNull(reference, "reference must be not null");
        return this.withReference((Matcher<String>)Matchers.equalTo((Object)reference));
    }

    public HttpClientVerifyBuilder withReference(Matcher<String> matcher) {
        Objects.requireNonNull(matcher, "matcher must be not null");
        this.ruleBuilder.setReferenceCondition(matcher);
        return this;
    }

    public HttpClientVerifyBuilder withParameter(String name, String value) {
        Objects.requireNonNull(name, "name must be not null");
        Objects.requireNonNull(value, "value must be not null");
        return this.withParameter(name, (Matcher<String>)Matchers.equalTo((Object)value));
    }

    public HttpClientVerifyBuilder withParameter(String name, Matcher<String> matcher) {
        Objects.requireNonNull(name, "name must be not null");
        Objects.requireNonNull(matcher, "matcher must be not null");
        this.ruleBuilder.setParameterCondition(name, matcher);
        return this;
    }

    public HttpClientVerifyBuilder with(Condition condition) {
        Objects.requireNonNull(condition, "condition must be not null");
        this.ruleBuilder.addCondition(condition);
        return this;
    }

    public HttpClientVerifyBuilder withBody(Matcher<String> matcher) {
        Objects.requireNonNull(matcher, "matcher must be not null");
        this.ruleBuilder.addCondition(new BodyCondition(matcher));
        return this;
    }

    public HttpClientVerifyBuilder withHost(String host) {
        Objects.requireNonNull(host, "host must be not null");
        this.ruleBuilder.addHostCondition(host);
        return this;
    }

    public HttpClientVerifyBuilder withPath(String path) {
        Objects.requireNonNull(path, "path must be not null");
        return this.withPath((Matcher<String>)Matchers.equalTo((Object)path));
    }

    public HttpClientVerifyBuilder withPath(Matcher<String> matcher) {
        Objects.requireNonNull(matcher, "matcher must be not null");
        this.ruleBuilder.setPathCondition(matcher);
        return this;
    }

    public void notCalled() {
        this.called(0);
    }

    public void called() {
        this.called(1);
    }

    public void called(int numberOfCalls) {
        this.called((Matcher<Integer>)Matchers.equalTo((Object)numberOfCalls));
    }

    public void called(Matcher<Integer> numberOfCalls) {
        Rule rule = this.ruleBuilder.build();
        int matchingCalls = (int)this.requests.stream().filter(rule::matches).count();
        if (!numberOfCalls.matches((Object)matchingCalls)) {
            throw new IllegalStateException(String.format("Expected %s calls, but found %s.", numberOfCalls, matchingCalls));
        }
    }
}

