/*
 * Decompiled with CFR 0.152.
 */
package com.pgssoft.httpclient;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MockedServerResponse {
    private final int statusCode;
    private final Map<String, List<String>> headers;
    private final ByteBuffer bodyBytes;

    private MockedServerResponse(int statusCode, Map<String, List<String>> headers, ByteBuffer bodyBytes) {
        this.statusCode = statusCode;
        this.headers = headers;
        this.bodyBytes = bodyBytes;
    }

    public int statusCode() {
        return this.statusCode;
    }

    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public ByteBuffer getBodyBytes() {
        return this.bodyBytes;
    }

    public static final class Builder {
        private int statusCode;
        private final Map<String, List<String>> headers = new HashMap<String, List<String>>();
        private ByteBuffer bodyBytes = ByteBuffer.wrap(new byte[0]);

        public void setStatusCode(int statusCode) {
            this.statusCode = statusCode;
        }

        public void addHeader(String key, String value) {
            this.headers.computeIfAbsent(key, k -> new ArrayList()).add(value);
        }

        public void setBodyBytes(ByteBuffer bodyBytes) {
            this.bodyBytes = bodyBytes;
        }

        public MockedServerResponse build() {
            return new MockedServerResponse(this.statusCode, this.headers, this.bodyBytes);
        }
    }
}

