/*
 * Decompiled with CFR 0.152.
 */
package com.pgssoft.httpclient.internal;

import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpHeaders;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Optional;
import javax.net.ssl.SSLSession;

public class HttpResponseProxy<T>
implements HttpResponse<T> {
    private final int statusCode;
    private final HttpHeaders headers;
    private final HttpRequest request;
    private final T body;

    public HttpResponseProxy(int statusCode, HttpHeaders headers, T body, HttpRequest request) {
        this.request = request;
        this.statusCode = statusCode;
        this.headers = headers;
        this.body = body;
    }

    @Override
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    public HttpRequest request() {
        return this.request;
    }

    @Override
    public Optional<HttpResponse<T>> previousResponse() {
        return Optional.empty();
    }

    @Override
    public HttpHeaders headers() {
        return this.headers;
    }

    @Override
    public T body() {
        return this.body;
    }

    @Override
    public Optional<SSLSession> sslSession() {
        return Optional.empty();
    }

    @Override
    public URI uri() {
        return this.request.uri();
    }

    @Override
    public HttpClient.Version version() {
        return this.request.version().orElse(HttpClient.Version.HTTP_1_1);
    }
}

